/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.oauth;

import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.oauth.KeyValue;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oauth2.PkceType;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OAuthFlow;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OAuth2RunningIdpConfiguration
extends CommonRunningIdpConfiguration {
    private final OAuth2IdpConfigurationData oauthIdpConfigurationData;

    public OAuth2RunningIdpConfiguration(@Nonnull OAuth2IdpConfigurationData oauthIdpConfigurationData, @Nullable AtlasUserAdapter atlasUserAdapter) {
        super(oauthIdpConfigurationData, atlasUserAdapter);
        this.oauthIdpConfigurationData = oauthIdpConfigurationData;
    }

    @Override
    public String getIdpId() {
        return this.oauthIdpConfigurationData.clientId;
    }

    public String getClientId() {
        return this.oauthIdpConfigurationData.clientId;
    }

    public String getClientSecret() {
        return this.oauthIdpConfigurationData.clientSecret;
    }

    public OAuthFlow getOauthFlow() {
        return this.oauthIdpConfigurationData.oAuthFlow;
    }

    public String getScopesAsString() {
        return String.join((CharSequence)" ", this.oauthIdpConfigurationData.scopes);
    }

    public List<String> getScopes() {
        return new ArrayList<String>(this.oauthIdpConfigurationData.scopes);
    }

    public String getAuthEndpoint() {
        return this.oauthIdpConfigurationData.authEndpoint;
    }

    public String getTokenEndpoint() {
        return this.oauthIdpConfigurationData.tokenEndpoint;
    }

    public List<String> getUserInfoEndpoints() {
        return new ArrayList<String>(this.oauthIdpConfigurationData.userInfoEndpoints);
    }

    public boolean isFetchUserInfo() {
        return this.oauthIdpConfigurationData.fetchUserInfo;
    }

    public List<KeyValue> getAdditionalAuthRequestParameters() {
        return new ArrayList<KeyValue>(this.oauthIdpConfigurationData.additionalAuthEndpointRequestParameters);
    }

    public List<KeyValue> getAdditionalTokenEndpointRequestParameters() {
        return new ArrayList<KeyValue>(this.oauthIdpConfigurationData.additionalTokenEndpointRequestParameters);
    }

    public List<KeyValue> getAdditionalUserInfoEndpointRequestParameters() {
        return new ArrayList<KeyValue>(this.oauthIdpConfigurationData.additionalUserInfoEndpointRequestParameters);
    }

    public List<KeyValue> getAuthEndpointRequestHeaders() {
        return new ArrayList<KeyValue>(this.oauthIdpConfigurationData.authEndpointRequestHeaders);
    }

    public List<KeyValue> getTokenEndpointRequestHeaders() {
        return new ArrayList<KeyValue>(this.oauthIdpConfigurationData.tokenEndpointRequestHeaders);
    }

    public List<KeyValue> getUserInfoEndpointRequestHeaders() {
        return new ArrayList<KeyValue>(this.oauthIdpConfigurationData.userInfoEndpointRequestHeaders);
    }

    public String getAuthScheme() {
        return this.oauthIdpConfigurationData.authScheme;
    }

    public boolean usePkce() {
        return this.oauthIdpConfigurationData.usePkce;
    }

    public PkceType getPkceMethod() {
        return this.oauthIdpConfigurationData.pkceMethod;
    }

    public boolean isSingleLoutoutEnabled() {
        return this.oauthIdpConfigurationData.doSingleLogout;
    }

    public String getEndSessionEndpoint() {
        return this.oauthIdpConfigurationData.endSessionEndpoint;
    }
}

