/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket.userauth;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.resolution.atlasplugins.samlsso.userauth.AbstractDirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.DirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.RemoteDirectoryAdapter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
@ExportAsService(value={DirectoryAdapter.class})
public class BitbucketDirectoryAdapter
extends AbstractDirectoryAdapter {
    private final UserService userService;
    private final SecurityService securityService;

    @Autowired
    public BitbucketDirectoryAdapter(RemoteDirectoryAdapter remoteDirectoryAdapter, @BitbucketImport TransactionTemplate transactionTemplate, @BitbucketImport DirectoryManager directoryManager, @BitbucketImport CrowdDirectoryService crowdDirectoryService, @BitbucketImport UserService userService, @BitbucketImport SecurityService securityService) {
        super(remoteDirectoryAdapter, transactionTemplate, directoryManager, crowdDirectoryService);
        this.userService = userService;
        this.securityService = securityService;
    }

    @Override
    @Nonnull
    public List<String> getGroupNames() {
        return Collections.emptyList();
    }

    @Override
    public boolean groupExists(String name) {
        return (Boolean)this.securityService.withPermission(Permission.SYS_ADMIN, "Check if group exists").call((Operation)((UncheckedOperation)() -> this.userService.existsGroup(name)));
    }
}

