(function () {

    var timeoutForLastIdP;

    // This is called after the page has loaded
    AJS.toInit(function () {
        // Hide these items
        AJS.$('#notFound').hide();
        AJS.$('#redirecting').hide();

        if(!pagedata.passwordLink) {
            AJS.$('#passwordLink').hide();
        }

        // The form is never submitted
        AJS.$("#emailAddressForm").submit(function (e) {
            e.preventDefault();
        });

        AJS.$("#emailAddressForm").click(function(e){
            cancelRedirectToLastIdp();
        });

        if(pagedata.showSendButton) {
            AJS.$("#checkEmailButton").click(function(e){
                checkEmailField();
            });
            AJS.$("#emailAddressField").on('input', function (e) {
                cancelRedirectToLastIdp();
            });
        } else {
            AJS.$("#checkEmailButton").hide();
            AJS.$("#emailAddressField").on('input', function (e) {
                checkEmailField();
            });
        }

        console.log("lastidp is " + pagedata.lastidp + " timeout is " + pagedata.redirectTimeout);
        console.log("last url is " + pagedata.lastSsourl);

        if(pagedata.lastidp !== 0 && pagedata.redirectTimeout > 0) {
            console.log('Setting timeout to ' + pagedata.redirectTimeout);
            timeoutForLastIdP = setTimeout(function() {
                console.log('Redirecting to last IdP...');
                AJS.$('#redirecting').hide();
                location.href = pagedata.lastSsourl;
            } , pagedata.redirectTimeout);
        } else {
            AJS.$('#waitForRedirect').hide()
        }
    });

    function cancelRedirectToLastIdp() {
        clearTimeout(timeoutForLastIdP);
        AJS.$('#waitForRedirect').hide();
    }

    function checkEmailField() {
        AJS.$('#notFound').hide();
        AJS.$('#redirecting').hide();
        cancelRedirectToLastIdp();

        // The input must have an @ and a . behind it to be ready to be checked
        var addressPattern = new RegExp(".*@.*\\...+");
        var enteredEmail = AJS.$("#emailAddressField").val();
        if (!addressPattern.test(enteredEmail)) {
            return;
        }
        var atPosition = enteredEmail.indexOf('@');
        if (atPosition < 0) {
            return;
        }
        var emailDomain = enteredEmail.substring(atPosition + 1).toLowerCase();
        if (!emailDomain) {
            return;
        }

        AJS.$.ajax({
            url: pagedata.checkEmailDomainUrl + emailDomain,
            dataType: "json",
            success: function (data) {
                console.log("Successfully retrieved IdP for given email domain", data);
                var idpId = data.idpId;
                if (idpId !== 0) {
                    AJS.$('#notFound').hide();
                    AJS.$('#redirecting').show();
                    AJS.$('#emailAddressField').prop('disabled', true);

                    redirectUrl = pagedata.ssoURL.replace('IDPID', idpId);
                    // This avoids a warning message when starting the redirect
                    window.onbeforeunload = function () {
                    };
                    window.location = redirectUrl;
                } else {
                    AJS.$('#notFound').show();
                }
            },
            error: function (xhr, errorText, err) {
                console.error("Error checking email domain: " + errorText, err);
                AJS.$('#notFound').show();
            }
        });
    }
})();
