/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.spi.Connector;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonAutoDetect
public interface ConnectorConfiguration {
    public static final String UNIQUE_ID = "uniqueId";
    public static final String CONNECTOR_CLASS = "connectorClass";
    public static final String UNKNOWN_ID = "unknown";
    public static final String DIRECTORY = "directoryId";

    @Nonnull
    public String getName();

    public void setName(@Nullable String var1);

    public long getDirectoryId();

    public void setDirectoryId(long var1);

    @Nonnull
    public List<AttributeTransformationConfig> getAttributeTransformationConfigs();

    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs();

    public boolean isDropUnmatchedGroups();

    @Nonnull
    public String getUniqueId();

    @Nonnull
    public List<String> getGroupsToAssignAlways();

    @Nonnull
    public List<String> getGroupsToAssignNever();

    @Nonnull
    public List<String> getGroupsToAssignFilter();

    @Nonnull
    public List<String> getGroupsToKeep();

    @Nonnull
    public List<String> getRequiredGroups();

    @Nonnull
    public String getDefaultFindByAttributeName();

    @Nonnull
    public CleanupBehaviour getCleanupBehaviour();

    public void setCleanupBehaviour(@Nonnull CleanupBehaviour var1);

    public boolean isUseGroovyCleanupDecider();

    public boolean isRemoveAllGroupAssignmentsOnCleanup();

    public void setRemoveAllGroupAssignmentsOnCleanup(boolean var1);

    @Nullable
    public String getGroovyCleanupDeciderCode();

    public boolean isOverrideReadOnlyDirectoryCheck();

    public boolean isScheduled();

    @Nonnull
    public String getCronExpression();

    @Nonnull
    public String getFindByAttributeName();

    @Nonnull
    public AtlasUserAdapter.CopyBehaviour getCopyBehaviour();

    @Nonnull
    public List<String> getRequiredConnectorGroups();

    @Nullable
    public String getRequiredConnectorGroupsGroovy();

    @Nullable
    public String getRequiredConnectorGroupsServerFilter();

    public boolean isUseRequiredConnectorGroupsGroovy();

    public boolean isUseRequiredConnectorGroupsServerFilter();

    public int getResultsToKeep();

    @Nonnull
    public ConnectorConfiguration sanitize();

    public int getVersion();

    public int getInitialVersion();

    @JsonIgnore
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass();

    default public String getConnectorClass() {
        return this.tellConnectorClass().getCanonicalName();
    }

    default public void setConnectorClass(String connectorClassName) {
    }

    public boolean isSyncEnabled();

    public boolean isDisableNotFoundUser();

    public AttributeTransformationConfig getDisableNotFoundLookupTransformation();

    public String getDisableNotFoundUserLookupAttribute();

    public boolean isIgnoreRequiredConnectorGroupsOnSingleUserSync();

    public boolean isTrackMemoryUsage();

    public List<String> getGroupsOrRegexNotBeRemoved();

    public int getSlowdownDelayInMs();
}

