/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.auditlog;

import com.atlassian.audit.api.AuditService;
import com.atlassian.sal.api.component.ComponentLocator;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.usersync.auditlog.AuditLogUtil;
import de.resolution.usersync.auditlog.NewApiUserSyncAuditLogService;
import de.resolution.usersync.auditlog.NoOpUserSyncAuditLogService;
import de.resolution.usersync.auditlog.UserSyncAuditLogService;
import de.resolution.usersync.spi.Connector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelegatingUserSyncAuditLogService
implements UserSyncAuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingUserSyncAuditLogService.class);
    private final UserSyncAuditLogService delegate;

    @Autowired
    public DelegatingUserSyncAuditLogService(AtlasCompatApiFactory atlasCompatApiFactory) {
        if (AuditLogUtil.supportsAuditLogApi(atlasCompatApiFactory)) {
            AuditService auditService = (AuditService)ComponentLocator.getComponent(AuditService.class);
            if (auditService == null) {
                logger.error("Failed to load AuditService.class, falling back to NoOp-Implementation!");
                this.delegate = new NoOpUserSyncAuditLogService();
            } else {
                this.delegate = new NewApiUserSyncAuditLogService(auditService);
            }
        } else {
            this.delegate = new NoOpUserSyncAuditLogService();
        }
    }

    @Override
    public void connectorUpdated(String connectorId, String oldConfiguration, String newConfiguration) {
        this.delegate.connectorUpdated(connectorId, oldConfiguration, newConfiguration);
    }

    @Override
    public void connectorCreated(Connector<?> connector) {
        this.delegate.connectorCreated(connector);
    }

    @Override
    public void connectorRemoved(@NotNull String uniqueId) {
        this.delegate.connectorRemoved(uniqueId);
    }
}

