AJS.$(function () {
    function waitForAndModifyLoginForm(selector) {
        console.debug('SAML SSO: Dashboard detected, waiting for login gadget or login page to load to inject IdP buttons');

        AJS.$.ajax({
            url: AJS.contextPath() + '/rest/samlsso-admin/1.0/idpSelectionButtons',
            dataType: "json",
            success: function (data) {
                let buttonNameAndIds = data

                if (buttonNameAndIds.length === 0) {
                    console.debug("SAML SSO: Did not get any IdP to display on the dashboard/login page")
                    return;
                }

                let retries = 10;

                const f = function () {
                    if (!modifyLoginForm(selector, buttonNameAndIds) && retries >= 0) {
                        retries -= 1;
                        setTimeout(f, 100);
                    }
                };

                setTimeout(f, 50);
            },
            error: function (error) {
                console.error("SAML SSO: Call to our backend did fail. This could mean a problem on our side or" +
                    " an issue on your side to connect to the backend. Do you may use an application firewall that " +
                    "blocks our REST requests?")
                console.error(error)
            }
        });
    }

    function modifyLoginForm(selector, buttonNameAndIds) {

        const $loginForm = $(selector);
        if (!$loginForm.length || $loginForm.attr('action').indexOf('WebSudo') !== -1) {
            console.debug('SAML SSO: Did not find a login form');
            return false;
        }


        if ($loginForm.attr('id') === 'loginform') {
            // in case on dashboard resize login gadget
            $loginForm.parent().parent().css('height', 'auto');
        }

        $loginForm.append("<br>")

        let div = AJS.$("<div class=\"buttons-container\"\" >");
        $loginForm.append(div)

        let destination = null;

        let currentUrlPath = window.location.pathname;

        if(currentUrlPath.includes('/servicedesk/customer')) {
            let currentUrlParameters = new URLSearchParams(window.location.search);
            let currentDestination = currentUrlParameters.get("destination");

            // This is a maybe ugly but working way to strip everything before
            // servicedesk/customer from the URL-path
            let splitted = currentUrlPath.split('servicedesk/customer');
            let strippedPath = splitted[0] + 'servicedesk/customer';

            if(currentDestination) {
                let decodedDestination = decodeURI(currentDestination);
                let separator = (decodedDestination.startsWith("/") || strippedPath.endsWith("/")) ? "" : "/";
                destination = encodeURI(strippedPath + separator + decodedDestination);
            }
        } else {
            let currentUrlParameters = new URLSearchParams(window.location.search);
            if (currentUrlParameters) {
                destination = currentUrlParameters.get("os_destination");
            }
        }
        console.debug("Destination: " + destination);

        buttonNameAndIds.forEach(function (labelAndId) {
            if (labelAndId.label !== "" && Number.isInteger(labelAndId.idpId)) {

                let params = new URLSearchParams({idp: labelAndId.idpId});
                if(destination) {
                    params.append("redirectTo", destination);
                }

                const idpButton = AJS.$(
                    "<a>", {
                        class: "aui-button",
                        text: labelAndId.label,
                        href: "/plugins/servlet/samlsso?" + params.toString()
                    })

                div.append(idpButton)
            }
        })

        return true;
    }

    (function () {
        let selectorForLoginForm = ""

        if (window.location.pathname.endsWith("Dashboard.jspa") || window.location.pathname.endsWith("login.jsp") || window.location.pathname.includes("servicedesk")) {
            // jira
            selectorForLoginForm = "#login-form, #loginform, #form-crowd-login"
        } else if (window.location.pathname.endsWith("login.action")) {
            // confluence
            selectorForLoginForm = "form.login-form-container"
        } else if (window.location.pathname.endsWith("login")) {
            // bitbucket
            selectorForLoginForm = ".aui, .top-label, .prevent-double-submit "
        } else if (window.location.pathname.endsWith("userlogin!doDefault.action")) {
            // bamboo
            selectorForLoginForm = "#loginForm"
        }

        if (selectorForLoginForm !== "") {
            waitForAndModifyLoginForm(selectorForLoginForm)
        }
    })();
});
