/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl.bamboo;

import com.atlassian.crowd.service.cluster.ClusterInformation;
import com.atlassian.crowd.service.cluster.ClusterNode;
import com.atlassian.crowd.service.cluster.ClusterService;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.component.ComponentLocator;
import de.resolution.usersync.impl.ClusterNodeInformation;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BambooComponent
@ExportAsService(value={ClusterNodeInformation.class})
public class BambooClusterNodeInformation
implements ClusterNodeInformation {
    private static final Logger logger = LoggerFactory.getLogger(BambooClusterNodeInformation.class);
    @Nullable
    private final ClusterService clusterService;
    @Nonnull
    private final String nodeId;

    public BambooClusterNodeInformation() {
        ClusterService locatedClusterService = (ClusterService)ComponentLocator.getComponent(ClusterService.class);
        if (locatedClusterService != null) {
            logger.debug("Located ClusterService");
            this.clusterService = locatedClusterService;
            this.nodeId = this.clusterService.getNodeId();
        } else {
            logger.debug("No ClusterService found, assuming this is no DC deployment.");
            this.clusterService = null;
            this.nodeId = "NOT_CLUSTERED";
        }
    }

    @Override
    @Nonnull
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    @Nonnull
    public Set<String> getAllNodeIds() {
        if (this.clusterService == null) {
            logger.debug("No ClusterService, assuming this is a single node.");
            return Collections.singleton(this.nodeId);
        }
        ClusterInformation info = this.clusterService.getInformation();
        Set<String> nodeIds = info.getNodes().stream().map(ClusterNode::getNodeId).collect(Collectors.toSet());
        if (logger.isDebugEnabled()) {
            logger.debug("Node IDs are {}", (Object)String.join((CharSequence)",", nodeIds));
        }
        return nodeIds;
    }

    @Override
    public Set<String> getActiveNodeIds() {
        return Collections.singleton(this.getNodeId());
    }

    @Override
    public ClusterNodeInformation.Product getProduct() {
        return ClusterNodeInformation.Product.BAMBOO;
    }
}

