/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.jit;

import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.jit.JitConnector;
import de.resolution.usersync.builtin.jit.JitConnectorConfiguration;
import de.resolution.usersync.builtin.jit.JitConnectorConfigurationImpl;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractConnectorFactory;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="jitConnectorFactory")
public class JitConnectorFactory
extends AbstractConnectorFactory<JitConnector, JitConnectorConfiguration> {
    private static final String KEY_DIRECTORY_ID = "directoryId";
    private final DirectoryAdapter directoryAdapter;

    @Inject
    public JitConnectorFactory(ConnectorService connectorService, DirectoryAdapter directoryAdapter, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
        this.directoryAdapter = directoryAdapter;
    }

    @Override
    @Nonnull
    public JitConnector create(@Nonnull JitConnectorConfiguration connectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new JitConnector(this.connectorService, connectorConfiguration, this.atlasUserAdapter, true, lastUpdated);
    }

    @Override
    @Nonnull
    public Class<JitConnector> getConnectorClass() {
        return JitConnector.class;
    }

    @Override
    @Nonnull
    public Class<JitConnectorConfiguration> getConfigurationClass() {
        return JitConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Just-in-Time";
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Use authentication attributes for user update";
    }

    @Override
    @Nonnull
    public JitConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        JitConnectorConfigurationImpl config = new JitConnectorConfigurationImpl();
        config.setName("Just-in-Time");
        config.setUniqueId(uniqueId);
        return config;
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull JitConnectorConfiguration config) {
        ValidationResult validationResult = super.validate(config);
        AtlasUserDirectory directory = this.directoryAdapter.get(config.getDirectoryId());
        if (directory == null) {
            validationResult.add(KEY_DIRECTORY_ID, "Directory must exist");
        } else if (!directory.isActive()) {
            validationResult.add(KEY_DIRECTORY_ID, "Directory must be active");
        } else if (!directory.isWritable()) {
            validationResult.add(KEY_DIRECTORY_ID, null, "Directory is not writable");
        }
        return validationResult;
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editJitConnector.json";
    }
}

