/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import javax.annotation.Nonnull;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;

public class Utils {
    public static final String CC_NO_CACHE_STRING;
    public static final CacheControl CC_NO_CACHE;
    private static final ObjectMapper objectMapper;
    private static final ObjectMapper nullsFixerObjectMapper;

    private Utils() {
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readFromClasspath(String filepath) {
        try (InputStream in = Utils.class.getResourceAsStream(filepath);){
            Scanner scanner = in == null ? null : new Scanner(in);
            try {
                String string;
                if (scanner == null) {
                    throw new FileNotFoundInClasspathException(filepath);
                }
                scanner.useDelimiter("\\A");
                String string2 = string = scanner.hasNext() ? scanner.next() : "";
                if (scanner != null) {
                    scanner.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (FileNotFoundInClasspathException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReadingFileFromClasspathFailedException(e);
        }
    }

    @Nonnull
    public static String toJson(Object object) {
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            return "{\"message\": \"" + e.getClass().getCanonicalName() + ": " + e.getMessage() + "\"}";
        }
    }

    public static Response toOkResponse(Object entity) {
        return Response.ok().cacheControl(CC_NO_CACHE).entity((Object)Utils.toJson(entity)).build();
    }

    public static Response toSimpleStatusResponse(Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)Utils.toJson(Collections.singletonMap("message", status.toString()))).cacheControl(CC_NO_CACHE).build();
    }

    public static void flattenAndIntegrateWithPrefix(Map<String, Object> output, String prefix, Map<String, Object> input) {
        for (Map.Entry<String, Object> stringObjectEntry : input.entrySet()) {
            Object value = stringObjectEntry.getValue();
            if (value == null) {
                value = "NULL";
            }
            output.put(prefix + "_" + stringObjectEntry.getKey(), value);
        }
    }

    public static Map<String, Object> fixNullsInMap(Map<String, Object> input) throws IOException {
        String mapAsString = nullsFixerObjectMapper.writeValueAsString(input);
        return (Map)nullsFixerObjectMapper.readValue(mapAsString, Map.class);
    }

    static {
        CC_NO_CACHE = new CacheControl();
        CC_NO_CACHE.setNoCache(true);
        CC_NO_CACHE.setNoStore(true);
        CC_NO_CACHE.setMustRevalidate(true);
        CC_NO_CACHE_STRING = CC_NO_CACHE.toString();
        objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        nullsFixerObjectMapper = new ObjectMapper();
        nullsFixerObjectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        nullsFixerObjectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        nullsFixerObjectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeFieldName("NULL");
            }
        });
        nullsFixerObjectMapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString("NULL");
            }
        });
    }

    public static class ReadingFileFromClasspathFailedException
    extends RuntimeException {
        public ReadingFileFromClasspathFailedException(Throwable cause) {
            super(cause);
        }
    }

    public static class FileNotFoundInClasspathException
    extends RuntimeException {
        public FileNotFoundInClasspathException(String identifier) {
            super("Could not find " + identifier + " in classpath");
        }
    }

    public static class FixedSizeCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        public FixedSizeCache(int size) {
            super(size + 2, 1.0f);
            this.maxSize = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

