/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.resolution.atlasplugins.samlsso.configuration.IdPType;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedIdPConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcIdpConfigurationData;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Target;
import java.util.List;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="protocolType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=SamlIdpConfigurationData.class, name="SAML"), @JsonSubTypes.Type(value=OidcIdpConfigurationData.class, name="OIDC"), @JsonSubTypes.Type(value=OAuth2IdpConfigurationData.class, name="OAU2")})
public abstract class CommonIdpConfigurationData
implements Comparable<CommonIdpConfigurationData>,
VersionedIdPConfiguration {
    public ProtocolType protocolType = ProtocolType.NONE;
    public IdPType idpType = IdPType.OTHER;
    public String idpId;
    public Integer weight;
    public Integer id = null;
    public String name;
    public String description;
    public String userSyncConnectorUID = "None";
    public AttributeTransformationConfig userSyncLookupTransformation = AttributeTransformationConfig.create((String)"ATTR_NAMEID", (Target.Type)Target.Type.NONE, (String)"US_LOOKUP");
    public boolean enableAdditionalAuthentication = true;
    public boolean useUrlFromRequest = false;
    public String findByAttributeName = "ATTR_NAME";
    public List<AttributeTransformationConfig> attributeTransformations = null;
    public UserUpdateMethod userUpdateMethod = UserUpdateMethod.NONE;
    public boolean enableUserReactivation = true;
    public boolean allowChangingActiveStateOnConnectorUpdate = false;
    public boolean shouldDisplayIdpButtonOnLoginPage = false;
    public String idpButtonText;

    @Override
    public VersionedIdPConfiguration migrateToNewerModelVersion() {
        return this;
    }

    protected CommonIdpConfigurationData() {
    }

    protected CommonIdpConfigurationData(CommonIdpConfigurationData other) {
        this.protocolType = other.protocolType;
        this.idpType = other.idpType;
        this.idpId = other.idpId;
        this.id = other.id;
        this.weight = other.weight;
        this.name = other.name;
        this.description = other.description;
        this.userSyncConnectorUID = other.userSyncConnectorUID;
        this.userSyncLookupTransformation = other.userSyncLookupTransformation;
        this.enableAdditionalAuthentication = other.enableAdditionalAuthentication;
        this.useUrlFromRequest = other.useUrlFromRequest;
        this.attributeTransformations = other.attributeTransformations;
        this.findByAttributeName = other.findByAttributeName;
        this.userUpdateMethod = other.userUpdateMethod;
        this.enableUserReactivation = other.enableUserReactivation;
        this.allowChangingActiveStateOnConnectorUpdate = other.allowChangingActiveStateOnConnectorUpdate;
        this.shouldDisplayIdpButtonOnLoginPage = other.shouldDisplayIdpButtonOnLoginPage;
        this.idpButtonText = other.idpButtonText;
    }

    @Override
    public int compareTo(@Nonnull CommonIdpConfigurationData other) {
        return this.weight.compareTo(other.weight);
    }

    public static enum UserUpdateMethod {
        NONE,
        SAML,
        CONNECTOR,
        CONNECTORANDSAML;

    }
}

