/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.commons.util.StringUtil;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectChecker {
    private static final String ILLEGAL_URL_END = ".js";
    private static final Logger logger = LoggerFactory.getLogger(RedirectChecker.class);

    private RedirectChecker() {
    }

    @Nonnull
    public static String getRedirectURL(@Nonnull List<String> illegalStrings, boolean isSkipBaseUrlCheck, @Nonnull String baseUrlForRequest, @Nonnull String relativeBaseUrl, @Nullable String redirectTarget, @Nonnull String defaultRelativeRedirectUrl, @Nonnull AuthenticationTracker tracker) {
        illegalStrings = illegalStrings.stream().filter(str -> !StringUtil.isNullOrEmpty((String)str)).collect(Collectors.toList());
        if (redirectTarget == null || redirectTarget.trim().isEmpty()) {
            logger.debug("RelayState is null or empty, setting it to {}", (Object)defaultRelativeRedirectUrl);
            return defaultRelativeRedirectUrl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RelayState is {}", (Object)StringUtil.sanitize((String)redirectTarget));
        }
        if (redirectTarget.startsWith("/") && !redirectTarget.startsWith("//")) {
            redirectTarget = relativeBaseUrl + redirectTarget;
        }
        if (isSkipBaseUrlCheck) {
            return redirectTarget;
        }
        if (RedirectChecker.containsIllegalCharsOrUrlEndingInRedirectTarget(illegalStrings, redirectTarget, tracker)) {
            return defaultRelativeRedirectUrl;
        }
        HttpUrl baseUrl = HttpUrl.parse((String)baseUrlForRequest);
        if (baseUrl == null) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Error checking redirect URL (baseUrl \"{}\" could not be resolved), redirecting to default redirect URL {}", new Object[]{baseUrlForRequest + redirectTarget, defaultRelativeRedirectUrl});
            return defaultRelativeRedirectUrl;
        }
        HttpUrl resolvedDestination = baseUrl.resolve(redirectTarget);
        if (resolvedDestination == null) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Could not resolve url to redirect to for {}{}", new Object[]{baseUrl, redirectTarget});
            return defaultRelativeRedirectUrl;
        }
        if (!baseUrl.host().equals(resolvedDestination.host())) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Destination to redirect to does not belong to base url. Destination is {}", new Object[]{resolvedDestination});
            return defaultRelativeRedirectUrl;
        }
        if (RedirectChecker.containsIllegalCharsOrUrlEndingInRedirectTarget(illegalStrings, resolvedDestination.encodedPath(), tracker)) {
            return defaultRelativeRedirectUrl;
        }
        if (!resolvedDestination.username().isEmpty() || !resolvedDestination.encodedUsername().isEmpty()) {
            if (logger.isWarnEnabled()) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Redirect URL {} contains userinfo and is considered as invalid!", new Object[]{StringUtil.sanitize((String)redirectTarget)});
            }
            return defaultRelativeRedirectUrl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Redirect URL {} is valid", (Object)StringUtil.sanitize((String)redirectTarget));
        }
        return redirectTarget;
    }

    @Nonnull
    public static String adjustOsDestinationIfNecessary(@Nonnull String osDestination) {
        if (!(osDestination.startsWith("/") || osDestination.startsWith("http://") || osDestination.startsWith("https://"))) {
            osDestination = "/" + osDestination;
        }
        return osDestination;
    }

    private static boolean containsIllegalCharsOrUrlEndingInRedirectTarget(List<String> illegalStrings, String toTest, AuthenticationTracker tracker) {
        toTest = toTest.toLowerCase(Locale.US);
        if (illegalStrings.stream().anyMatch(toTest::contains) || toTest.startsWith("/s/") && toTest.endsWith(ILLEGAL_URL_END) || toTest.startsWith("%2f%2f")) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "The resolved url contains an illegal string: {}", new Object[]{toTest});
            return true;
        }
        return false;
    }
}

