/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.rest.certificate;

import de.resolution.commons.cert.api.CertificateCheckResult;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;

public class CertificateCheckResultTransferObject {
    public final String message;
    public final boolean certSet;
    public final boolean valid;
    public final boolean expired;
    public final boolean hasPrivateKey;
    public final Map<String, Object> info;

    public CertificateCheckResultTransferObject(CertificateCheckResult result) {
        this.message = result.getMessage();
        this.certSet = result.isCertSet();
        this.valid = result.isValid();
        this.expired = result.isExpired();
        this.hasPrivateKey = result.hasPrivateKey();
        this.info = new HashMap<String, Object>();
        if (result.getSerialNumber() != null) {
            this.info.put("serialNumber", result.getSerialNumber().toString());
        }
        this.info.put("issuerDN", result.getIssuerDN());
        this.info.put("notBefore", result.getNotBefore());
        this.info.put("notAfter", result.getNotAfter());
        this.info.put("subjectDN", result.getSubjectDN());
        if (result.getPublicKey() instanceof RSAPublicKey) {
            RSAPublicKey rsaPk = (RSAPublicKey)result.getPublicKey();
            this.info.put("publicKey", rsaPk.getAlgorithm());
            this.info.put("format", rsaPk.getFormat());
            if (rsaPk.getModulus() != null) {
                this.info.put("modulus", rsaPk.getModulus().toString(16));
            }
            if (rsaPk.getPublicExponent() != null) {
                this.info.put("publicExponent", rsaPk.getPublicExponent().toString(16));
            }
        } else if (result.getPublicKey() != null) {
            this.info.put("publicKey", result.getPublicKey().toString());
        }
        this.info.put("sigAlgName", result.getSigAlgName());
        this.info.put("sigAlgOID", result.getSigAlgOID());
        this.info.put("signature", result.getSignature());
        this.info.put("subjectAlternateNames", result.getSubjectAlternateNames());
    }
}

