/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.FecruComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.license.LicenseHandler;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.reconfigure.ApplicationInformationImpl;
import de.resolution.reconfigure.MutableApplicationInformationImpl;
import de.resolution.reconfigure.api.ApplicationInformation;
import de.resolution.reconfigure.api.ApplicationInformationProvider;
import de.resolution.reconfigure.api.MutableApplicationInformation;
import de.resolution.reconfigure.readonlymode.ReconfigureReadOnlyModeDetector;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
@ConfluenceComponent
@BitbucketComponent
@BambooComponent
@FecruComponent
@ExportAsService
public class DefaultApplicationInformationProvider
implements ApplicationInformationProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultApplicationInformationProvider.class);
    private final ApplicationProperties applicationProperties;
    private final LoginUriProvider loginUriProvider;
    private final AtlasCompatApiFactory atlasCompatApiFactory;
    private final ReconfigureReadOnlyModeDetector readOnlyModeDetector;
    private final LicenseHandler licenseHandler;
    private final Optional<AnalyticsConfigService> analyticsConfigService;

    @Inject
    public DefaultApplicationInformationProvider(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport LicenseHandler licenseHandler, AtlasCompatApiFactory atlasCompatApiFactory, ReconfigureReadOnlyModeDetector readOnlyModeDetector) {
        this.applicationProperties = applicationProperties;
        this.loginUriProvider = loginUriProvider;
        this.atlasCompatApiFactory = atlasCompatApiFactory;
        this.readOnlyModeDetector = readOnlyModeDetector;
        this.licenseHandler = licenseHandler;
        this.analyticsConfigService = this.loadAnalyticsConfigService();
    }

    @Nonnull
    private Optional<AnalyticsConfigService> loadAnalyticsConfigService() {
        logger.debug("Trying to load AnalyticsConfigService");
        OsgiContainerManager osgiContainerManager = (OsgiContainerManager)ComponentLocator.getComponent(OsgiContainerManager.class);
        if (osgiContainerManager == null) {
            logger.debug("Could not load AnalyticsConfigService because OsgiContainerManager is not available");
            return Optional.empty();
        }
        ServiceTracker serviceTracker = osgiContainerManager.getServiceTracker("com.atlassian.analytics.api.services.AnalyticsConfigService");
        if (serviceTracker == null) {
            logger.debug("Could not load AnalyticsConfigService because ServiceTracker is not available");
            return Optional.empty();
        }
        Object service = serviceTracker.getService();
        if (service == null) {
            logger.debug("Could not load AnalyticsConfigService because ServiceTracker did not return the service");
            return Optional.empty();
        }
        logger.debug("AnalyticsConfigService seems to be available");
        return Optional.of((AnalyticsConfigService)service);
    }

    @Override
    public ApplicationInformation getApplicationInformation(String frontendUrl) {
        return new ApplicationInformationImpl(this.applicationProperties, this.atlasCompatApiFactory, this.loginUriProvider, this.licenseHandler, frontendUrl, false);
    }

    @Override
    public ApplicationInformation getApplicationInformation(String frontendUrl, boolean isSupportInfo) {
        return new ApplicationInformationImpl(this.applicationProperties, this.atlasCompatApiFactory, this.loginUriProvider, this.licenseHandler, frontendUrl, isSupportInfo);
    }

    @Override
    public MutableApplicationInformation getMutableApplicationInformation() {
        return new MutableApplicationInformationImpl(this.readOnlyModeDetector.isReadOnlyMode());
    }

    @Override
    public boolean canCollectAnalytics() {
        if (this.analyticsConfigService.isPresent()) {
            return this.analyticsConfigService.get().canCollectAnalytics();
        }
        logger.error("Could not detect if analytics can be collected because AnalyticsConfigService is not present");
        return false;
    }
}

