/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import de.resolution.commons.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/idpSelectionButtons")
@AnonymousAllowed
public class IdpButtonsOnLoginPageRestResource {
    private final SamlSsoService samlSsoService;

    @Autowired
    public IdpButtonsOnLoginPageRestResource(SamlSsoService samlSsoService) {
        this.samlSsoService = samlSsoService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest request) throws JsonProcessingException {
        List labels = this.samlSsoService.getRunningConfiguration().getRunningIdPConfigurations().stream().filter(CommonRunningIdpConfiguration::shouldDisplayIdpButtonOnLoginPage).map(idp -> {
            if (!StringUtil.isNullOrEmpty((String)idp.getIdpButtonText())) {
                return new IdpButton(idp.getIdpButtonText(), idp.getId());
            }
            return new IdpButton(idp.getName(), idp.getId());
        }).collect(Collectors.toList());
        if (labels.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)Utils.asJson(labels)).cacheControl(Utils.ccNoCache).build();
    }

    private static class IdpButton {
        private final String label;
        private final Integer idpId;

        @JsonCreator
        IdpButton(@JsonProperty(value="label") String label, @JsonProperty(value="idpId") Integer idpId) {
            this.label = label;
            this.idpId = idpId;
        }

        public String getLabel() {
            return this.label;
        }

        public Integer getIdpId() {
            return this.idpId;
        }
    }
}

