/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.frontend;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.ResourceLoader;
import com.resolution.atlasplugins.samlsso.SAMLSSORuntimeException;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.configuration.frontend.AttributeMappingTemplateProviderForMoreProtocols;
import de.resolution.retransform.frontend.AttributeMappingTemplate;
import de.resolution.retransform.frontend.AttributeMappingTemplateMap;
import de.resolution.retransform.frontend.TargetTypeMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class AttributeMappingTemplateProviderForMoreProtocolsImpl
implements AttributeMappingTemplateProviderForMoreProtocols {
    private final Map<ProtocolType, AttributeMappingTemplateMap> templates = new EnumMap<ProtocolType, AttributeMappingTemplateMap>(ProtocolType.class);
    private static final String TEMPLATE_PATH = "data/attributeMappingTemplates";

    public AttributeMappingTemplateProviderForMoreProtocolsImpl() {
        Arrays.stream(ProtocolType.values()).forEach(type -> {
            if (type != ProtocolType.NONE) {
                this.loadTargetTypes((ProtocolType)((Object)type));
                this.applyDefaults((ProtocolType)((Object)type));
            }
        });
    }

    private void loadTargetTypes(ProtocolType type) {
        List filenames = ResourceLoader.listFiles("data/attributeMappingTemplates/" + type.name()).stream().filter(name -> name.matches(".*\\.json$")).filter(name -> !name.equals("defaults.json")).collect(Collectors.toList());
        for (String filename : filenames) {
            this.loadTargetTypeMap(type, filename);
        }
    }

    private void applyDefaults(ProtocolType type) {
        try {
            String json = ResourceLoader.load("data/attributeMappingTemplates/" + type.name() + "/defaults.json");
            TargetTypeMap defaultTargetTypes = (TargetTypeMap)new ObjectMapper().readValue(json, TargetTypeMap.class);
            for (TargetTypeMap idpTargetTypes : this.templates.get((Object)type).values()) {
                for (Map.Entry<String, AttributeMappingTemplateMap.TargetNameMap> defaultTargetTypeEntry : defaultTargetTypes.entrySet()) {
                    String defaultTargetTypeKey = defaultTargetTypeEntry.getKey();
                    AttributeMappingTemplateMap.TargetNameMap defaultTargetNameMap = defaultTargetTypeEntry.getValue();
                    if (!idpTargetTypes.containsKey(defaultTargetTypeKey)) {
                        idpTargetTypes.put(defaultTargetTypeKey, defaultTargetNameMap);
                        continue;
                    }
                    AttributeMappingTemplateMap.TargetNameMap currentIdPTargetNameMap = (AttributeMappingTemplateMap.TargetNameMap)idpTargetTypes.get(defaultTargetTypeKey);
                    for (Map.Entry<String, List<AttributeMappingTemplate>> defaultMappingTemplateEntry : defaultTargetNameMap.entrySet()) {
                        String defaultTargetNameKey = defaultMappingTemplateEntry.getKey();
                        List<AttributeMappingTemplate> templateList = defaultMappingTemplateEntry.getValue();
                        currentIdPTargetNameMap.putIfAbsent(defaultTargetNameKey, templateList);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SAMLSSORuntimeException("Loading AttributeMappingTemplatesFailed", e);
        }
    }

    private void loadTargetTypeMap(ProtocolType type, String filename) {
        try {
            String json = ResourceLoader.load(filename);
            TargetTypeMap targetTypeMap = (TargetTypeMap)new ObjectMapper().readValue(json, TargetTypeMap.class);
            AttributeMappingTemplateMap map = this.templates.get((Object)type);
            if (map != null) {
                map.put(ResourceLoader.stripPathAndExtension(filename), targetTypeMap);
                this.templates.put(type, map);
            } else {
                AttributeMappingTemplateMap tmp = new AttributeMappingTemplateMap();
                tmp.put(ResourceLoader.stripPathAndExtension(filename), targetTypeMap);
                this.templates.put(type, tmp);
            }
        }
        catch (IOException e) {
            throw new SAMLSSORuntimeException("Loading AttributeMappingTemplates from file " + filename + " failed", e);
        }
    }

    @Override
    public Map<ProtocolType, AttributeMappingTemplateMap> getTemplatesForAllProtocols() {
        return this.templates;
    }

    @Override
    public AttributeMappingTemplateMap getTemplates(ProtocolType type) {
        return this.templates.get((Object)type);
    }

    @Override
    public AttributeMappingTemplateMap getAttributeMappingTemplates() {
        return new AttributeMappingTemplateMap();
    }
}

