/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.util.StringUtil;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PatchRequest {
    @Nonnull
    private final List<PatchOperation> operations = new ArrayList<PatchOperation>();
    private static final Script OPERATIONS_EXPRESSION = StructuredData.prepareFind((String)"Operations");
    private static final Script PATH_EXPRESSION = StructuredData.prepareFind((String)"path");
    private static final Script OP_EXPRESSION = StructuredData.prepareFind((String)"op");
    private static final Script VALUE_EXPRESSION = StructuredData.prepareFind((String)"value");

    @Nonnull
    public static PatchRequest fromJson(@Nullable String json) throws ScimException {
        if (StringUtil.isNullOrEmpty((String)json)) {
            throw new BadRequestException("Empty request", "invalidValue");
        }
        StructuredData structuredData = StructuredData.parseJson((String)json);
        StructuredData operations = structuredData.find(OPERATIONS_EXPRESSION);
        if (operations == null || operations.isEmpty() || !operations.isList()) {
            throw new BadRequestException("The body of an HTTP PATCH request MUST contain the attribute \"Operations\", whose value is an array of one or more PATCH operations.", "invalidValue");
        }
        PatchRequest patchRequest = new PatchRequest();
        for (StructuredData operation : operations.asList()) {
            Op op = Op.fromString(operation.findString(OP_EXPRESSION));
            String path = operation.findString(PATH_EXPRESSION);
            StructuredData valueData = operation.findOrEmpty(VALUE_EXPRESSION);
            if (StringUtil.isNullOrEmpty((String)path)) {
                if (valueData.isMap()) {
                    for (Map.Entry stringStructuredDataEntry : valueData.asMap().entrySet()) {
                        if (StringUtil.isNullOrEmpty((String)((String)stringStructuredDataEntry.getKey()))) {
                            throw new BadRequestException("PATCH operation does not contain path", "noTarget");
                        }
                        patchRequest.addOperation(new PatchOperation(op, (String)stringStructuredDataEntry.getKey(), (StructuredData)stringStructuredDataEntry.getValue()));
                    }
                    continue;
                }
                throw new BadRequestException("PATCH operation does not contain path", "noTarget");
            }
            patchRequest.addOperation(new PatchOperation(op, path, valueData));
        }
        return patchRequest;
    }

    private void addOperation(PatchOperation patchOperation) {
        this.operations.add(patchOperation);
    }

    @Nonnull
    public List<PatchOperation> getOperations() {
        return this.operations;
    }

    static class PatchOperation {
        @Nonnull
        private final Op op;
        @Nonnull
        private final String path;
        @Nonnull
        private final StructuredData value;

        public PatchOperation(@Nonnull Op op, @Nonnull String path, @Nonnull StructuredData value) {
            this.op = op;
            this.path = path;
            this.value = value;
        }

        @Nonnull
        public Op getOp() {
            return this.op;
        }

        @Nonnull
        public String getPath() {
            return this.path;
        }

        @Nonnull
        public StructuredData getValue() {
            return this.value;
        }
    }

    static enum Op {
        ADD,
        REPLACE,
        REMOVE;


        public static Op fromString(@Nullable String opString) throws BadRequestException {
            if (StringUtil.isNullOrEmpty((String)opString)) {
                throw new BadRequestException("The PATCH operation object MUST contain \"op\"", "invalidValue");
            }
            for (Op value : Op.values()) {
                if (!value.name().equalsIgnoreCase(opString)) continue;
                return value;
            }
            throw new BadRequestException("The op value is not of type \"add\", \"remove\", or \"replace\"", "invalidValue");
        }
    }
}

