/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.excel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.builtin.excel.ExcelImporterConnectorConfiguration;
import de.resolution.usersync.spi.AbstractConnector;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImporterConnector
extends AbstractConnector<ExcelImporterConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(ExcelImporterConnector.class);
    public static final String FILENAME_STORAGE_VALUE = "excelFile";
    @JsonIgnore
    private final DataFormatter formatter = new DataFormatter();
    @JsonIgnore
    private FormulaEvaluator formulaEvaluator;

    public ExcelImporterConnector(ExcelImporterConnectorConfiguration configuration, ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/empty.json");
    }

    @Override
    public void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        String filename = this.getConnectorStorageValue(FILENAME_STORAGE_VALUE).orElse(null);
        if (filename == null) {
            syncStatusFacade.fail("Could not read file", logger);
            return;
        }
        File file = new File(filename);
        try (Workbook wb = WorkbookFactory.create((File)file);){
            this.formulaEvaluator = wb.getCreationHelper().createFormulaEvaluator();
            Sheet sheet = wb.getSheetAt(0);
            Iterator rowIt = sheet.rowIterator();
            LinkedHashMap<String, Integer> headerMap = this.readHeaderMap((Row)rowIt.next());
            if (logger.isDebugEnabled()) {
                logger.debug("=== HEADER MAP ===");
                for (Map.Entry<String, Integer> entry : headerMap.entrySet()) {
                    logger.debug("{} : {}", (Object)entry.getKey(), (Object)entry.getValue());
                }
                logger.debug("==================");
            }
            while (rowIt.hasNext()) {
                Row currentRow = (Row)rowIt.next();
                Map<String, List<String>> userAttributes = this.readUserAttributes(currentRow, headerMap);
                syncFunction.accept(StructuredData.create(userAttributes));
                syncStatusFacade.checkCancel();
            }
        }
        catch (Exception e) {
            syncStatusFacade.fail(e.getMessage(), e, logger);
        }
        try {
            Files.delete(file.toPath());
            syncStatusFacade.add("Deleted " + filename, null, SyncStatusFacade.LogLevel.DEBUG, logger);
        }
        catch (IOException e) {
            syncStatusFacade.add("Deleting XLSX-file " + filename + " failed.", e, SyncStatusFacade.LogLevel.WARN, logger);
        }
        this.removeConnectorStorageValue(FILENAME_STORAGE_VALUE);
        try {
            this.connectorService.reloadConnectorIntoCache(this.getUniqueId());
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException | ConnectorNotFoundException e) {
            syncStatusFacade.add("Reloading connector failed!", e, SyncStatusFacade.LogLevel.ERROR, logger);
        }
    }

    private LinkedHashMap<String, Integer> readHeaderMap(Row row) {
        LinkedHashMap<String, Integer> headerMap = new LinkedHashMap<String, Integer>();
        String lastKey = null;
        for (int i = 0; i <= row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            if (cell != null) {
                String evaluatedValue = this.formatter.formatCellValue(cell, this.formulaEvaluator);
                if (evaluatedValue != null && !evaluatedValue.isEmpty()) {
                    lastKey = evaluatedValue;
                    headerMap.put(lastKey, 0);
                    continue;
                }
                int oldCount = headerMap.get(lastKey);
                int newCount = oldCount + 1;
                headerMap.put(lastKey, newCount);
                continue;
            }
            logger.debug("Cell {} is null", (Object)i);
            int oldCount = headerMap.get(lastKey);
            int newCount = oldCount + 1;
            headerMap.put(lastKey, newCount);
        }
        return headerMap;
    }

    private Map<String, List<String>> readUserAttributes(Row row, LinkedHashMap<String, Integer> headerMap) {
        int index = 0;
        HashMap<String, List<String>> attributeMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, Integer> entry : headerMap.entrySet()) {
            String key = entry.getKey();
            int count = entry.getValue();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = index; i <= index + count; ++i) {
                String value;
                Cell cell = row.getCell(i);
                if (cell != null && (value = this.formatter.formatCellValue(cell, this.formulaEvaluator)) != null && !value.isEmpty()) {
                    values.add(value);
                }
                if (values.isEmpty()) continue;
                attributeMap.put(key, values);
            }
            index = index + count + 1;
        }
        return attributeMap;
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        return FindUserResult.failed("findUser is not implemented");
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Import users from Excel";
    }

    @Override
    public List<String> getConnectorAttributes() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return false;
    }

    @Override
    public boolean isAllowCustomAttributeMapping() {
        return false;
    }

    @Override
    public boolean isAllowSelectingFindByAttribute() {
        return false;
    }

    @Override
    public boolean isSelectableGroupAttribute() {
        return false;
    }

    @Override
    public boolean isSelectableDirectory() {
        return true;
    }

    @Override
    public boolean isAllowGroupConfiguration() {
        return false;
    }

    @Override
    public boolean isCanSyncSingleUser() {
        return false;
    }

    @Override
    public boolean isApplyTransformations() {
        return false;
    }

    @Override
    public boolean isCleanupConfigurable() {
        return false;
    }

    @Override
    public boolean isCanBeScheduled() {
        return false;
    }

    @Override
    @Nonnull
    public Class<ExcelImporterConnectorConfiguration> getConfigurationClass() {
        return ExcelImporterConnectorConfiguration.class;
    }

    @Override
    public boolean isCanHaveRequiredGroups() {
        return false;
    }

    @Override
    public boolean isHasProvisioningSettings() {
        return false;
    }
}

