/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.tracker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.resolution.samlwrapper.api.tracker.ExceptionInfo;

public class ImmutableExceptionInfo
implements ExceptionInfo {
    private final ExceptionInfo cause;
    private final String className;
    private final String message;

    @JsonCreator
    public ImmutableExceptionInfo(@JsonProperty(value="cause") ImmutableExceptionInfo cause, @JsonProperty(value="className") String className, @JsonProperty(value="message") String message) {
        this.cause = cause;
        this.className = className;
        this.message = message;
    }

    public ImmutableExceptionInfo(Throwable ex) {
        Throwable causeEx = ex.getCause();
        this.cause = causeEx != null ? new ImmutableExceptionInfo(causeEx) : null;
        this.className = ex.getClass().getCanonicalName();
        this.message = ex.getMessage();
    }

    public ExceptionInfo getCause() {
        return this.cause;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMessage() {
        return this.message;
    }
}

