/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.bamboo.userauth.BambooAuthenticatorHook;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class RedirectToLogoutBambooFilter
implements Filter {
    private final BambooAuthenticatorHook bambooAuthenticatorHook;
    private final SamlSsoService samlssoService;
    private static final Logger logger = LoggerFactory.getLogger(RedirectToLogoutBambooFilter.class);

    @Autowired
    public RedirectToLogoutBambooFilter(BambooAuthenticatorHook bambooAuthenticatorHook, SamlSsoService samlSsoService) {
        this.bambooAuthenticatorHook = bambooAuthenticatorHook;
        this.samlssoService = samlSsoService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String redirectUrl;
        if (logger.isDebugEnabled()) {
            logger.debug("Call to Bamboo logout intercepted. User isLoggedIn? {}", (Object)this.bambooAuthenticatorHook.isLoggedInUser((HttpServletRequest)servletRequest));
        }
        if ((redirectUrl = this.samlssoService.executeLogout((HttpServletRequest)servletRequest)) != null) {
            ((HttpServletResponse)servletResponse).sendRedirect(redirectUrl);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

