/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence.userauth;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import com.resolution.atlasplugins.samlsso.userauth.AbstractSamlUserMigrator;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
public class ConfluenceSamlUserMigrator
extends AbstractSamlUserMigrator {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceSamlUserMigrator.class);
    private final UserAccessor userAccessor;

    @Autowired
    public ConfluenceSamlUserMigrator(AtlasUserAdapter atlasUserAdapter, @ConfluenceImport UserAccessor userAccessor) {
        super(atlasUserAdapter);
        this.userAccessor = userAccessor;
    }

    @Override
    public boolean isLegacySamlUser(@Nonnull String userid) {
        ConfluenceUser user = this.userAccessor.getUserByName(userid);
        if (user == null) {
            logger.debug("ConfluenceUser is null for userid {}.", (Object)userid);
            return false;
        }
        PropertySet userProperties = this.userAccessor.getPropertySet(user);
        if (userProperties == null) {
            logger.debug("UserProperties for user {} are null.", (Object)userid);
            return false;
        }
        try {
            return userProperties.getBoolean("createdFromSAMLSingleSignOn");
        }
        catch (PropertyException e) {
            logger.debug("Could not read property {} from user {}.", (Object)"createdFromSAMLSingleSignOn", (Object)userid);
            return false;
        }
    }
}

