/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.group;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.unflattener.JsonUnflattener;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import de.resolution.commons.util.JSONUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScimCoreGroup {
    public static final String SCHEMA_CORE_GROUP = "urn:ietf:params:scim:schemas:core:2.0:Group";
    @Nonnull
    private final Map<String, Object> attributes;

    public ScimCoreGroup(@Nonnull Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Nonnull
    public static ScimCoreGroupBuilder builder() {
        return new ScimCoreGroupBuilder();
    }

    @Nullable
    @JsonIgnore
    public String getId() {
        Object id = this.attributes.get("id");
        if (id instanceof String) {
            return (String)id;
        }
        return null;
    }

    @Nullable
    @JsonIgnore
    public String getDisplayName() {
        Object id = this.attributes.get("displayName");
        if (id instanceof String) {
            return (String)id;
        }
        return null;
    }

    @Nullable
    @JsonIgnore
    public List<String> getMembers() {
        Object id = this.attributes.get("members");
        if (id instanceof List) {
            return (List)id;
        }
        return null;
    }

    @Nonnull
    @JsonAnyGetter
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static class ScimCoreGroupBuilder {
        @Nonnull
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        public ScimCoreGroupBuilder() {
            this.attributes.put("schemas", Collections.singleton(ScimCoreGroup.SCHEMA_CORE_GROUP));
        }

        @Nonnull
        public ScimCoreGroupBuilder with(@Nonnull String key, @Nullable Object value) {
            if (value == null && this.attributes.containsKey(key)) {
                this.attributes.remove(key);
            } else {
                this.attributes.put(key, value);
            }
            return this;
        }

        public ScimCoreGroupBuilder without(@Nonnull String key) {
            this.attributes.remove(key);
            return this;
        }

        @Nonnull
        public ScimCoreGroup build() throws ScimException {
            Map unflattenedMap;
            String flattenedJson = JSONUtil.asJson(this.attributes);
            String unflattenedJson = new JsonUnflattener(flattenedJson).withFlattenMode(FlattenMode.MONGODB).unflatten();
            ObjectMapper mapper = new ObjectMapper();
            try {
                unflattenedMap = (Map)mapper.readValue(unflattenedJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new ServerErrorException("Building SCIM user failed: " + e.getMessage(), null, (Throwable)e);
            }
            return new ScimCoreGroup(unflattenedMap);
        }
    }
}

