/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.analytics;

import com.google.common.hash.Hashing;
import de.resolution.reconfigure.analytics.ConfigAnalyticsPayload;
import de.resolution.reconfigure.api.AnalyticsProvider;
import de.resolution.reconfigure.api.ApplicationInformation;
import de.resolution.reconfigure.api.ApplicationInformationProvider;
import de.resolution.reconfigure.api.ConfigurationLoadFailedException;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.api.PluginInformation;
import de.resolution.reconfigure.api.PluginInformationProvider;
import de.resolution.reconfigure.api.SystemInformation;
import de.resolution.reconfigure.api.SystemInformationApplication;
import de.resolution.reconfigure.api.SystemInformationApplicationProvider;
import de.resolution.reconfigure.api.SystemInformationProvider;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AnalyticsProviderImpl
implements AnalyticsProvider {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsProviderImpl.class);
    private final ConfigurationService<?> configurationService;
    private final ApplicationInformationProvider applicationInformationProvider;
    private final PluginInformationProvider pluginInformationProvider;
    private final SystemInformationProvider systemInformationProvider;
    private final SystemInformationApplicationProvider systemInformationApplicationProvider;
    private final String pluginKey;
    private final String schedulerKey;

    @Inject
    public AnalyticsProviderImpl(ConfigurationService<?> configurationService, ApplicationInformationProvider applicationInformationProvider, PluginInformationProvider pluginInformationProvider, SystemInformationProvider systemInformationProvider, SystemInformationApplicationProvider systemInformationApplicationProvider) {
        this.configurationService = configurationService;
        this.applicationInformationProvider = applicationInformationProvider;
        this.pluginInformationProvider = pluginInformationProvider;
        this.systemInformationProvider = systemInformationProvider;
        this.systemInformationApplicationProvider = systemInformationApplicationProvider;
        this.pluginKey = pluginInformationProvider.getPluginInformation(null).getPluginKey();
        this.schedulerKey = this.pluginKey + "__reconfigure.analytics.heartbeat";
    }

    @Override
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Override
    public String getSchedulerKey() {
        return this.schedulerKey;
    }

    @Override
    public String getInstanceFingerprint() {
        ApplicationInformation applicationInformation = this.applicationInformationProvider.getApplicationInformation(null);
        String serverId = applicationInformation.getApplicationServerId();
        if (serverId == null) {
            serverId = "_NO_SERVER_ID_";
        }
        String serverBaseUrl = applicationInformation.getApplicationBaseUrl();
        String hashBase = serverId + "__" + serverBaseUrl;
        return this.sha256Hash(hashBase);
    }

    @Override
    public String getAppInstanceFingerprint() {
        String instanceIdentifierHashed = this.getInstanceFingerprint();
        String hashBase = instanceIdentifierHashed + "__" + this.pluginKey;
        return this.sha256Hash(hashBase);
    }

    @Override
    public int getEffectiveAnalyticsConsentLevel(Integer previewConsentLevel) throws ConfigurationLoadFailedException {
        int analyticsConsentLevel = previewConsentLevel == null ? this.configurationService.getAnalyticsConsentLevel() : previewConsentLevel.intValue();
        if (analyticsConsentLevel == 0) {
            analyticsConsentLevel = this.applicationInformationProvider.canCollectAnalytics() ? 1 : -1;
        }
        return analyticsConsentLevel;
    }

    public Map<String, Object> getHostAnalyticsPayload(PluginInformation pluginInformation, SystemInformation systemInformation, SystemInformationApplication systemInformationApplication) {
        HashMap<String, Object> analyticsPayload = new HashMap<String, Object>();
        analyticsPayload.put("name", pluginInformation.getHostApplication().toLowerCase(Locale.ROOT));
        analyticsPayload.put("version", pluginInformation.getHostApplicationVersion());
        analyticsPayload.put("osName", systemInformation.getOsName());
        analyticsPayload.put("osArchitecture", systemInformation.getOsArchitecture());
        analyticsPayload.put("jvmName", systemInformation.getJvmName());
        analyticsPayload.put("jvmVersion", systemInformation.getJvmVersion());
        analyticsPayload.put("dbName", systemInformationApplication.getDbName());
        analyticsPayload.put("dbVersion", systemInformationApplication.getDbVersion());
        analyticsPayload.put("clustering", systemInformationApplication.getClustering());
        return analyticsPayload;
    }

    public Map<String, Object> getLicenseAnalyticsPayload(PluginInformation pluginInformation) {
        HashMap<String, Object> analyticsPayload = new HashMap<String, Object>();
        analyticsPayload.put("type", pluginInformation.getLicenseType());
        analyticsPayload.put("size", pluginInformation.getLicenseSize());
        analyticsPayload.put("eval", pluginInformation.getEvaluationLicense());
        return analyticsPayload;
    }

    public Map<String, Object> getPluginPayload(PluginInformation pluginInformation) {
        HashMap<String, Object> analyticsPayload = new HashMap<String, Object>();
        analyticsPayload.put("version", pluginInformation.getPluginVersion());
        analyticsPayload.put("key", pluginInformation.getPluginKey());
        analyticsPayload.put("family", this.configurationService.getPluginFamily());
        return analyticsPayload;
    }

    @Override
    public Optional<ConfigAnalyticsPayload> getAnalyticsPayload(Integer previewConsentLevel) throws ConfigurationLoadFailedException {
        int analyticsConsentLevel = this.getEffectiveAnalyticsConsentLevel(previewConsentLevel);
        PluginInformation pluginInformation = this.pluginInformationProvider.getPluginInformation(null);
        SystemInformation systemInformation = this.systemInformationProvider.getSystemInformation();
        SystemInformationApplication systemInformationApplication = this.systemInformationApplicationProvider.getSystemInformationApplication();
        if (analyticsConsentLevel < 0) {
            return Optional.empty();
        }
        ConfigAnalyticsPayload configAnalyticsPayload = new ConfigAnalyticsPayload();
        configAnalyticsPayload.pluginKey = this.pluginKey;
        configAnalyticsPayload.pluginFamily = this.configurationService.getPluginFamily();
        configAnalyticsPayload.instanceFingerprint = this.getInstanceFingerprint();
        configAnalyticsPayload.appInstanceFingerprint = this.getAppInstanceFingerprint();
        configAnalyticsPayload.config = this.configurationService.getAnalyticsData(analyticsConsentLevel);
        configAnalyticsPayload.plugin = this.getPluginPayload(pluginInformation);
        configAnalyticsPayload.host = this.getHostAnalyticsPayload(pluginInformation, systemInformation, systemInformationApplication);
        configAnalyticsPayload.license = this.getLicenseAnalyticsPayload(pluginInformation);
        logger.debug("Creating analytics information successful");
        return Optional.of(configAnalyticsPayload);
    }

    private String sha256Hash(String input) {
        return Hashing.sha256().hashString((CharSequence)input, StandardCharsets.UTF_8).toString();
    }
}

