/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.Utils;
import de.resolution.commons.util.StringUtil;
import de.resolution.samlauth.api.AdditionalAuthenticationData;
import de.resolution.samlauth.api.AdditionalAuthenticationService;
import de.resolution.samlauth.api.AdditionalAuthenticationStatus;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/additionalauth")
public class AdditionalAuthenticationRestResource {
    private final AdditionalAuthenticationService additionalAuthenticationService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(AdditionalAuthenticationRestResource.class);

    @Autowired
    public AdditionalAuthenticationRestResource(AdditionalAuthenticationService additionalAuthenticationService) {
        this.additionalAuthenticationService = additionalAuthenticationService;
    }

    @POST
    @Path(value="/new")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createNewAdditionalAuthentication(String createNewStatusDTOString, @Context HttpServletRequest request) {
        CreateNewStatusDTO createNewStatusDTO;
        try {
            createNewStatusDTO = (CreateNewStatusDTO)this.objectMapper.readValue(createNewStatusDTOString, CreateNewStatusDTO.class);
        }
        catch (IOException e) {
            logger.warn("Could not parse CreateNewStatusDTO from {}", (Object)StringUtil.sanitize((String)createNewStatusDTOString), (Object)e);
            return Response.status((int)400).build();
        }
        AdditionalAuthenticationData authenticationData = this.additionalAuthenticationService.requestAuthentication(request, createNewStatusDTO.getConfirmationMessage());
        return Response.ok().entity((Object)Utils.asJsonString(authenticationData)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/enabled")
    public Response isAdditionalAuthenticationEnabled(@Context HttpServletRequest request) {
        return Response.ok().entity((Object)Utils.asJsonString(new IsAdditionalAuthenticationEnabledResult(this.additionalAuthenticationService.isEnabledAndSamlSession(request)))).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/status/{id}")
    public Response getStatus(@PathParam(value="id") String id, @Context HttpServletRequest request) {
        AdditionalAuthenticationStatus status = this.additionalAuthenticationService.getStatus(id);
        if (status == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().entity((Object)Utils.asJsonString(status)).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/ack/{token}")
    public Response acknowledge(@PathParam(value="token") String token, @Context HttpServletRequest request) {
        if (this.additionalAuthenticationService.confirm(token)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @JsonAutoDetect
    public static class CreateNewStatusDTO {
        private final String confirmationMessage;

        @JsonCreator
        public CreateNewStatusDTO(@JsonProperty(value="confirmationMessage") String confirmationMessage) {
            this.confirmationMessage = confirmationMessage;
        }

        public String getConfirmationMessage() {
            return this.confirmationMessage;
        }
    }

    @JsonAutoDetect
    public static class IsAdditionalAuthenticationEnabledResult {
        private final boolean enabled;

        public IsAdditionalAuthenticationEnabledResult(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

