/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence.userauth;

import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerImpl;
import com.resolution.atlasplugins.samlsso.userauth.AbstractAuthenticatorHook;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHookException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent(value="authenticatorHook")
public class ConfluenceAuthenticatorHook
extends AbstractAuthenticatorHook {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceAuthenticatorHook.class);
    private DefaultAuthenticator authenticator;
    private LoginManager loginManager;
    private UserAccessor userAccessor;
    private CrowdService crowdService;
    private DirectoryManager directoryManager;
    private ApplicationService applicationService;
    private ApplicationDAO applicationDao;
    private DirectoryInstanceLoader directoryLoader;
    private EventPublisher eventPublisher;

    @Autowired
    public ConfluenceAuthenticatorHook(@ConfluenceImport TransactionTemplate transactionTemplate, @ConfluenceImport LoginManager loginManager, @ConfluenceImport UserAccessor userAccessor, @ConfluenceImport CrowdService crowdService, @ConfluenceImport DirectoryManager directoryManager) {
        logger.debug("Creating ConfluenceAuthenticatorHook...");
        this.loginManager = loginManager;
        this.userAccessor = userAccessor;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        Authenticator originalAuthenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (!(originalAuthenticator instanceof DefaultAuthenticator)) {
            throw new AuthenticatorHookException("This authenticator of type " + originalAuthenticator.getClass().getCanonicalName() + "is not a DefaultAuthenticator.", (AuthenticationTracker)new AuthenticationTrackerImpl("INITIAL"));
        }
        this.authenticator = (DefaultAuthenticator)originalAuthenticator;
    }

    @Override
    public boolean isCrowdAuthenticator() {
        return Objects.equals(this.getAuthenticatorClass(), "com.atlassian.confluence.user.ConfluenceCrowdSSOAuthenticator");
    }

    @Override
    public boolean isDenyPasswordAuthenticator() {
        return Objects.equals(this.authenticator.getClass().getCanonicalName(), "de.resolution.samlsso.authenticator.ConfluenceDenyPasswordAuthenticator");
    }

    @Override
    public boolean isNoSysadminDenyPasswordAuthenticator() {
        return Objects.equals(this.authenticator.getClass().getCanonicalName(), "de.resolution.samlsso.authenticator.ConfluenceDenyPasswordForSysadminsAuthenticator");
    }

    @Override
    public String getAuthenticatorClass() {
        return this.authenticator.getClass().getCanonicalName();
    }

    @Override
    public boolean isLoggedInUser(HttpServletRequest request) {
        return AuthenticatedUserThreadLocal.get() != null;
    }

    @Override
    public boolean doAuthoriseUserAndEstablishSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Principal principal, boolean sdCustomerLogin, AuthenticationTracker tracker) {
        Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
        if (principal == null) {
            logger.error("Principal must not be null!");
            return false;
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(principal.getName());
        if (confluenceUser == null) {
            throw new AuthenticatorHookException("ConfluenceUser is null", tracker);
        }
        if (this.userAccessor.isDeactivated((User)confluenceUser)) {
            throw new AuthenticatorHookException("User is not enabled", tracker);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Principal name is: %s, class is: %s", principal.getName(), principal.getClass().getCanonicalName()));
        }
        try {
            String DIRECT_LOGIN = "com.atlassian.confluence.login.direct";
            httpServletRequest.setAttribute("com.atlassian.confluence.login.direct", (Object)true);
            String methodName = "authoriseUserAndEstablishSession";
            Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Principal.class};
            Object[] parameters = new Object[]{httpServletRequest, httpServletResponse, principal};
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.authenticator, parameters);
            if (returnValue instanceof Boolean) {
                boolean authenticated = (Boolean)returnValue;
                if (logger.isDebugEnabled()) {
                    logger.debug("authoriseUserAndEstablishSession returned {}", (Object)authenticated);
                }
                if (authenticated) {
                    this.loginManager.onSuccessfulLoginAttempt(principal.getName(), httpServletRequest);
                    com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(principal.getName());
                    Map<String, Set<String>> attrMap = Collections.singletonMap("lastAuthenticated", Collections.singleton(String.valueOf(new Date().getTime())));
                    try {
                        this.directoryManager.storeUserAttributes(user.getDirectoryId(), user.getName(), attrMap);
                    }
                    catch (Exception e) {
                        tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Setting lastAuthenticatedAttribute failed", new Object[0]);
                        tracker.add(e);
                    }
                }
                return authenticated;
            }
            throw new AuthenticatorHookException("Authenticator method did not return a boolean, but a " + returnValue.getClass().getCanonicalName(), tracker);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new AuthenticatorHookException(e, tracker);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticatorHookException(e.getCause(), tracker);
        }
    }

    private void triggerUserAuthenticatedEvent(Application application, Directory directory, com.atlassian.crowd.model.user.User user) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Firing UserAuthenticatedEvent for User %s in Directory %s", user.getName(), directory.getName()));
        }
        this.getEventPublisher().publish((Object)new UserAuthenticatedEvent((Object)this.getApplicationService(), directory, application, user));
    }

    private ApplicationService getApplicationService() {
        if (this.applicationService == null) {
            this.applicationService = (ApplicationService)ContainerManager.getComponent((String)"crowdApplicationService");
        }
        return this.applicationService;
    }

    private ApplicationDAO getApplicationDao() {
        if (this.applicationDao == null) {
            this.applicationDao = (ApplicationDAO)ContainerManager.getComponent((String)"embeddedCrowdApplicationDao");
        }
        return this.applicationDao;
    }

    private Iterable<Directory> getActiveLdapDirectories(Application application) {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)application.getDirectoryMappings(), (Function)new Function<DirectoryMapping, Directory>(){

            public Directory apply(DirectoryMapping from) {
                return from.getDirectory();
            }
        }), (Predicate)new Predicate<Directory>(){

            public boolean apply(Directory from) {
                return from.isActive() && (from.getType().equals((Object)DirectoryType.DELEGATING) || from.getType().equals((Object)DirectoryType.CONNECTOR));
            }
        });
    }

    private DirectoryInstanceLoader getDirectoryLoader() {
        if (this.directoryLoader == null) {
            this.directoryLoader = (DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader");
        }
        return this.directoryLoader;
    }

    private EventPublisher getEventPublisher() {
        if (this.eventPublisher == null) {
            this.eventPublisher = (EventPublisher)ContainerManager.getInstance().getContainerContext().getComponent((Object)"eventPublisher");
        }
        return this.eventPublisher;
    }

    @Override
    protected DefaultAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

