/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.spring.container.ContainerManager;
import com.resolution.atlasplugins.samlsso.ReadOnlyModeDetector;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class ConfluenceReadOnlyModeDetector
implements ReadOnlyModeDetector {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceReadOnlyModeDetector.class);
    private Object accessModeServiceObject;
    private Method isReadOnlyAccessModeEnabledMethod;

    public ConfluenceReadOnlyModeDetector() {
        try {
            Object component = ContainerManager.getComponent((String)"accessModeService");
            if (component != null) {
                logger.debug("Found component {}", (Object)component.getClass().getCanonicalName());
                try {
                    this.isReadOnlyAccessModeEnabledMethod = component.getClass().getMethod("isReadOnlyAccessModeEnabled", new Class[0]);
                    this.accessModeServiceObject = component;
                }
                catch (Throwable t) {
                    this.accessModeServiceObject = null;
                }
            } else {
                this.accessModeServiceObject = null;
            }
        }
        catch (Throwable t) {
            logger.debug("Loading accessModeService failed, assuming that ReadOnly-Mode is not available on this system.");
            this.accessModeServiceObject = null;
            this.isReadOnlyAccessModeEnabledMethod = null;
        }
    }

    @Override
    public boolean isReadOnlyMode() {
        if (this.accessModeServiceObject != null && this.isReadOnlyAccessModeEnabledMethod != null) {
            try {
                Object result = this.isReadOnlyAccessModeEnabledMethod.invoke(this.accessModeServiceObject, new Object[0]);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                logger.error("Unexpected return type {} of isReadOnlyAccessModeEnabled(), assuming that Read-Only mode is not enabled.", (Object)result.getClass().getCanonicalName());
                return false;
            }
            catch (Exception e) {
                logger.error("Invoking isReadOnlyAccessModeEnabled() via reflection failed, assuming that Read-Only mode is not enabled", (Throwable)e);
                return false;
            }
        }
        return false;
    }
}

