/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bamboo.userauth;

import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.user.User;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import com.resolution.atlasplugins.samlsso.userauth.AbstractSamlUserMigrator;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent
public class BambooSamlUserMigrator
extends AbstractSamlUserMigrator {
    private static final Logger logger = LoggerFactory.getLogger(BambooSamlUserMigrator.class);
    private final BambooUserManager bambooUserManager;

    @Autowired
    public BambooSamlUserMigrator(AtlasUserAdapter atlasUserAdapter, @BambooImport BambooUserManager bambooUserManager) {
        super(atlasUserAdapter);
        this.bambooUserManager = bambooUserManager;
    }

    @Override
    public boolean isLegacySamlUser(@Nonnull String userid) {
        String SAMLSSOATTRIBUTEKEY = "createdFromSAMLSingleSignOn";
        User user = this.bambooUserManager.getUser(userid);
        PropertySet userProperties = this.bambooUserManager.getPropertySet(user);
        if (userProperties == null) {
            logger.debug("UserProperties for user {} are null.", (Object)userid);
            return false;
        }
        try {
            return userProperties.getBoolean("createdFromSAMLSingleSignOn");
        }
        catch (PropertyException e) {
            logger.debug("Could not read property {} from user {}.", (Object)"createdFromSAMLSingleSignOn", (Object)userid);
            return false;
        }
    }
}

