/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bamboo.userauth;

import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.spring.container.ContainerManager;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerImpl;
import com.resolution.atlasplugins.samlsso.userauth.AbstractAuthenticatorHook;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHookException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.util.JSONUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.context.SecurityContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@BambooComponent(value="AuthenticatorHook")
public class BambooAuthenticatorHook
extends AbstractAuthenticatorHook {
    private final Logger logger = LoggerFactory.getLogger(BambooAuthenticatorHook.class);
    private final DefaultAuthenticator authenticator;
    private final BambooAuthenticationContext bambooAuthenticationContext;
    private final BambooUserManager bambooUserManager;
    private final AtlasUserAdapter atlasUserAdapter;

    @Autowired
    public BambooAuthenticatorHook(@BambooImport BambooAuthenticationContext bambooAuthenticationContext, @BambooImport BambooUserManager bambooUserManager, AtlasUserAdapter atlasUserAdapter) {
        this.bambooAuthenticationContext = bambooAuthenticationContext;
        this.bambooUserManager = bambooUserManager;
        this.atlasUserAdapter = atlasUserAdapter;
        Authenticator originalAuthenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (!(originalAuthenticator instanceof DefaultAuthenticator)) {
            throw new AuthenticatorHookException("This authenticator of type " + originalAuthenticator.getClass().getCanonicalName() + " is not a DefaultAuthenticator.", (AuthenticationTracker)new AuthenticationTrackerImpl("INITIAL"));
        }
        this.authenticator = (DefaultAuthenticator)originalAuthenticator;
    }

    @Override
    public boolean isLoggedInUser(HttpServletRequest httpServletRequest) {
        return this.bambooAuthenticationContext.getUser() != null;
    }

    @Override
    public String getAuthenticatorClass() {
        return this.authenticator.getClass().getCanonicalName();
    }

    @Override
    public boolean isCrowdAuthenticator() {
        return Objects.equals(this.getAuthenticatorClass(), "com.atlassian.crowd.integration.seraph.v25.BambooAuthenticator");
    }

    @Override
    public boolean isDenyPasswordAuthenticator() {
        return Objects.equals(this.authenticator.getClass().getCanonicalName(), "de.resolution.samlsso.authenticator.BambooDenyPasswordAuthenticator");
    }

    @Override
    public boolean isNoSysadminDenyPasswordAuthenticator() {
        return Objects.equals(this.authenticator.getClass().getCanonicalName(), "de.resolution.samlsso.authenticator.BambooDenyPasswordForSysadminsAuthenticator");
    }

    @Override
    public boolean doAuthoriseUserAndEstablishSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Principal principal, boolean sdCustomerLogin, AuthenticationTracker tracker) {
        Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
        if (principal == null) {
            this.logger.error("Principal must not be null!");
            return false;
        }
        BambooUser bambooUser = this.bambooUserManager.getBambooUser(principal.getName());
        if (bambooUser == null) {
            throw new AuthenticatorHookException("BambooUser is null", tracker);
        }
        if (!bambooUser.isEnabled()) {
            throw new AuthenticatorHookException("BambooUser is not enabled", tracker);
        }
        this.logger.debug("Principal name is: {}, class is: {}", (Object)principal.getName(), (Object)principal.getClass().getCanonicalName());
        try {
            String methodName = "authoriseUserAndEstablishSession";
            Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Principal.class};
            Object[] parameters = new Object[]{httpServletRequest, httpServletResponse, principal};
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.authenticator, parameters);
            if (returnValue instanceof Boolean) {
                boolean authenticated = (Boolean)returnValue;
                this.logger.debug("authoriseUserAndEstablishSession returned {}", (Object)authenticated);
                if (authenticated) {
                    LoginInformationManager loginInformationManager = (LoginInformationManager)ContainerManager.getComponent((String)"loginInformationManager");
                    loginInformationManager.resetFailedLoginAttemptsCount(principal.getName());
                    AtlasUserResult readResult = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create((String)"ATTR_NAME", (Object)principal.getName(), (long)-1L));
                    if (readResult.getOperation() != AtlasUserResult.Operation.FAILED) {
                        Optional readUserOpt = readResult.getResultingUser();
                        AtlasUser toUpdate = AtlasUser.builder().findBy("ATTR_NAME", (Object)principal.getName()).in(((AtlasUser)readUserOpt.get()).getReference().getDirectoryId()).with("lastAuthenticated", new Object[]{String.valueOf(System.currentTimeMillis())}).build();
                        AtlasUserResult updateResult = this.atlasUserAdapter.update(toUpdate);
                        if (updateResult.getOperation() == AtlasUserResult.Operation.FAILED) {
                            tracker.add(this.logger, SAMLAuthenticationTracker.Level.WARNING, "Updating {} at {} failed: {}", new Object[]{"lastAuthenticated", principal.getName(), JSONUtil.asJson((Object)updateResult)});
                        } else {
                            tracker.add(this.logger, SAMLAuthenticationTracker.Level.DEBUG, "Updated {}: {}", new Object[]{"lastAuthenticated", JSONUtil.asJson((Object)readResult)});
                        }
                    } else {
                        tracker.add(this.logger, SAMLAuthenticationTracker.Level.WARNING, "Reading AtlasUser for updating {} failed: {}", new Object[]{"lastAuthenticated", JSONUtil.asJson((Object)readResult)});
                    }
                }
                return authenticated;
            }
            throw new AuthenticatorHookException("Authenticator method did not return a boolean, but a " + returnValue.getClass().getCanonicalName(), tracker);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new AuthenticatorHookException(e, tracker);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticatorHookException(e.getCause(), tracker);
        }
    }

    @Override
    protected DefaultAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public boolean logout(HttpServletRequest req, HttpServletResponse resp, AuthenticationTracker tracker) {
        boolean logoutSuccessful = super.logout(req, resp, tracker);
        SecurityContextHolder.clearContext();
        return logoutSuccessful;
    }
}

