/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.auditlog;

import com.atlassian.audit.api.AuditService;
import com.atlassian.sal.api.component.ComponentLocator;
import com.resolution.atlasplugins.samlsso.auditlog.AuditLogService;
import com.resolution.atlasplugins.samlsso.auditlog.NewApiAuditLogService;
import com.resolution.atlasplugins.samlsso.auditlog.NoOpAuditLogService;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.usersync.auditlog.AuditLogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelegatingAuditLogService
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingAuditLogService.class);
    private final AuditLogService delegate;

    @Autowired
    public DelegatingAuditLogService(AtlasCompatApiFactory atlasCompatApiFactory) {
        if (AuditLogUtil.supportsAuditLogApi(atlasCompatApiFactory)) {
            AuditService auditService = (AuditService)ComponentLocator.getComponent(AuditService.class);
            if (auditService == null) {
                logger.error("Failed to load AuditService.class, falling back to NoOp-Implementation!");
                this.delegate = new NoOpAuditLogService();
            } else {
                this.delegate = new NewApiAuditLogService(auditService);
            }
        } else {
            this.delegate = new NoOpAuditLogService();
        }
    }

    @Override
    public void logConfigurationUpdate(ConfigurationData oldConfig, ConfigurationData newConfig) {
        this.delegate.logConfigurationUpdate(oldConfig, newConfig);
    }
}

