/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSyncPluginProperties {
    private static final Logger logger;
    private static final Properties properties;

    private UserSyncPluginProperties() {
    }

    public static String get(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} : {}", (Object)key, properties.get(key));
        }
        return properties.getProperty(key);
    }

    static {
        InputStream is;
        logger = LoggerFactory.getLogger(UserSyncPluginProperties.class);
        properties = new Properties();
        try {
            is = UserSyncPluginProperties.class.getResourceAsStream("/plugin.properties");
            try {
                if (is != null) {
                    properties.load(is);
                } else {
                    logger.error("Cannot load plugin.properties, InputStream is null");
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("Loading plugin.properties failed!", (Throwable)e);
        }
        try {
            is = UserSyncPluginProperties.class.getResourceAsStream("/usersync-embedded.properties");
            try {
                if (is != null) {
                    properties.load(is);
                } else {
                    logger.error("Cannot load /usersync-embedded.properties, InputStream is null");
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("Loading /usersync-embedded.properties failed!", (Throwable)e);
        }
    }
}

