/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.SAMLWrapperConfiguration;
import com.resolution.samlwrapper.api.SAMLWrapperIdpConfiguration;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.AttributeTransformationConfigTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRunningIdPConfiguration
extends CommonRunningIdpConfiguration
implements SAMLWrapperIdpConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SamlRunningIdPConfiguration.class);
    private final SamlIdpConfigurationData samlIdpConfigurationData;
    private final Map<String, AttributeTransformer> attributeTransformerMap;

    public SamlRunningIdPConfiguration(SamlIdpConfigurationData samlIdpConfigurationData, String applicationPrefix, @Nullable AtlasUserAdapter atlasUserAdapter) {
        super(samlIdpConfigurationData, atlasUserAdapter);
        this.samlIdpConfigurationData = samlIdpConfigurationData;
        HashMap<String, List<String>> staticValues = new HashMap<String, List<String>>();
        if (!CollectionUtil.isNullOrEmpty(samlIdpConfigurationData.organizationsForNewSdCustomers)) {
            staticValues.put("JIRA.ATTR_ORGANIZATIONS", samlIdpConfigurationData.organizationsForNewSdCustomers);
        }
        this.attributeTransformerMap = new AttributeTransformationConfigTranslator(samlIdpConfigurationData.attributeTransformations).withProfilePrefix(applicationPrefix).withAddTheseStaticValues(staticValues).withDropAllIfValuesDontMatchAnyOfThese(Collections.emptyMap()).withRemoveValuesMatchingAnyOfThese(Collections.emptyMap()).withDropAllIfValuesDontMatchAnyOfThese(Collections.emptyMap()).withAtlasUserAdapter(atlasUserAdapter).translate();
        if (logger.isDebugEnabled()) {
            logger.debug("Loaded Idp Configuration: {}", (Object)Utils.asJsonString(this));
        }
    }

    public List<String> getDefaultUserGroups() {
        if (this.samlIdpConfigurationData.groupsForNewUsers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.samlIdpConfigurationData.groupsForNewUsers);
    }

    public List<String> getDefaultSDCustomerGroups() {
        if (this.samlIdpConfigurationData.groupsForNewSdCustomers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.samlIdpConfigurationData.groupsForNewSdCustomers);
    }

    public String getRequestUrlOverride() {
        return this.samlIdpConfigurationData.requestUrlOverride;
    }

    public String getPostBindingURL() {
        return this.samlIdpConfigurationData.postBindingURL;
    }

    public String getPostBindingLogoutURL() {
        return this.samlIdpConfigurationData.postBindingLogoutURL;
    }

    public String getRedirectBindingURL() {
        return this.samlIdpConfigurationData.redirectBindingURL;
    }

    public String getRedirectBindingLogoutURL() {
        return this.samlIdpConfigurationData.redirectBindingLogoutURL;
    }

    @Override
    public boolean isUseUrlFromRequest() {
        return this.samlIdpConfigurationData.useUrlFromRequest;
    }

    public List<String> getCertificatePEMs() {
        return this.samlIdpConfigurationData.certificates;
    }

    public boolean isSingleLoutoutEnabled() {
        return this.samlIdpConfigurationData.selectedLogoutBinding != SamlIdpConfigurationData.LogoutBinding.DISABLE;
    }

    public String getEntityId() {
        return this.samlIdpConfigurationData.idpId;
    }

    @Nonnull
    public List<String> getAcceptedIssuers() {
        return new ArrayList<String>(this.samlIdpConfigurationData.acceptedIssuers);
    }

    @Override
    public String getIdpId() {
        return this.samlIdpConfigurationData.idpId;
    }

    public String getRelayStateParameterName() {
        return this.samlIdpConfigurationData.relayStateParameterName;
    }

    public boolean isSignRequests() {
        return this.samlIdpConfigurationData.signRequests;
    }

    public SAMLWrapper.Binding getSelectedLoginBinding() {
        return this.samlIdpConfigurationData.selectedLoginBinding;
    }

    public boolean isAcceptUnsignedLogoutResponse() {
        return this.samlIdpConfigurationData.acceptUnsignedLogoutResponse;
    }

    public boolean isSignLogoutResponse() {
        return this.samlIdpConfigurationData.signLogoutResponse;
    }

    public SAMLWrapper.Binding getSelectedLogoutBinding() {
        if (this.samlIdpConfigurationData.selectedLogoutBinding == SamlIdpConfigurationData.LogoutBinding.REDIRECT) {
            return SAMLWrapper.Binding.REDIRECT;
        }
        return SAMLWrapper.Binding.POST;
    }

    public SAMLWrapper.NameIdFormat getNameIdFormatInRequest() {
        return this.samlIdpConfigurationData.nameIdFormatInRequest;
    }

    public boolean isAcceptUnsignedLogoutRequest() {
        return this.samlIdpConfigurationData.acceptUnsignedLogoutRequest;
    }

    public boolean isAcceptLogoutRequestWithoutSessionIndex() {
        return this.samlIdpConfigurationData.acceptLogoutRequestWithoutSessionIndex;
    }

    public boolean isSendLogoutResponseAfterLogoutRequest() {
        return this.samlIdpConfigurationData.sendLogoutResponseAfterLogoutRequest;
    }

    public SAMLWrapperIdpConfiguration.AuthnContextComparisonType getAuthnContextComparisonType() {
        return this.samlIdpConfigurationData.authnContextComparisonType;
    }

    public List<String> getAuthnContextClassRefs() {
        return this.samlIdpConfigurationData.authnContextClassRefs;
    }

    public List<String> getAuthnContextDeclRefs() {
        return this.samlIdpConfigurationData.authnContextDeclRefs;
    }

    public SAMLWrapper.ProtocolBindingOfResponse getProtocolBindingOfResponse() {
        return this.samlIdpConfigurationData.protocolBindingOfResponse;
    }

    public boolean isCheckCertificateValidity() {
        return this.samlIdpConfigurationData.denyMessagesSignedWithExpiredCertificates;
    }

    public boolean isValidateAudience() {
        return this.samlIdpConfigurationData.isValidateAudience;
    }

    public boolean isValidateDestination() {
        return this.samlIdpConfigurationData.isValidateDestination;
    }

    @Override
    public boolean isEnableUserReactivation() {
        return this.samlIdpConfigurationData.enableUserReactivation;
    }

    public boolean isAddNonExistingGroups() {
        return this.samlIdpConfigurationData.addNonExistingGroups;
    }

    public boolean isRemoveFromGroups() {
        return this.samlIdpConfigurationData.removeFromGroups;
    }

    public boolean isAddNonExistingOrganizations() {
        return this.samlIdpConfigurationData.addNonExistingOrganizations;
    }

    public boolean isEnableUserCreation() {
        return this.samlIdpConfigurationData.enableUserCreation;
    }

    public boolean isEnableUserRenaming() {
        return this.samlIdpConfigurationData.enableUserRenaming;
    }

    public long getDirectoryIdForNewUsers() {
        return this.samlIdpConfigurationData.directoryIdForNewUsers;
    }

    public boolean isUpdateExisting() {
        return this.samlIdpConfigurationData.updateExisting;
    }

    public String getPostBindingLogoutResponseURL() {
        return this.samlIdpConfigurationData.postBindingLogoutResponseURL;
    }

    public String getRedirectBindingLogoutResponseURL() {
        return this.samlIdpConfigurationData.redirectBindingLogoutResponseURL;
    }

    @Override
    public String getFindByAttributeName() {
        return this.samlIdpConfigurationData.findByAttributeName;
    }

    public Map<String, AttributeTransformer> getAttributeTransformerMap() {
        return Collections.unmodifiableMap(this.attributeTransformerMap);
    }

    public List<AttributeTransformationConfig> getAttributeTransformationConfigs() {
        return Collections.unmodifiableList(this.samlIdpConfigurationData.attributeTransformations);
    }

    public SAMLWrapperConfiguration.TrueFalseNone getWantAssertionsSigned() {
        return this.samlIdpConfigurationData.wantAssertionsSigned;
    }

    public SAMLWrapperConfiguration.TrueFalseNone getAuthnRequestsSigned() {
        return this.samlIdpConfigurationData.authnRequestsSigned;
    }

    public boolean isIncludeSigningCertificateInMetadata() {
        return this.samlIdpConfigurationData.includeSigningCertificateInMetadata;
    }

    public boolean isIncludeEncryptionCertificateInMetadata() {
        return this.samlIdpConfigurationData.includeEncryptionCertificateInMetadata;
    }

    public boolean isIncludeLogoutUrlInMetadata() {
        return this.samlIdpConfigurationData.includeLogoutUrlInMetadata;
    }

    public boolean isIncludeUrlInRelayState() {
        return this.samlIdpConfigurationData.includeUrlInRelayState;
    }

    public boolean isForceAuthenticationForAdditionalAuthentication() {
        return this.samlIdpConfigurationData.forceAuthenticationForAdditionalAuthentication;
    }

    public boolean isUsingMetadataXml() {
        return this.samlIdpConfigurationData.useMetadataxml;
    }

    public boolean isMetadataAutoReloadEnabled() {
        return this.samlIdpConfigurationData.autoReloadMetadata;
    }
}

