/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserKeys;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.SetUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.helpers.LozengeStyle;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.rest.entities.SyncStatusDiffResultEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Named(value="syncStatusDiffRestResource")
@Path(value="/usersync/syncStatusDiff")
public class SyncStatusDiffRestResource {
    private static final int MAX_NUMBER_ATTR_VALUES_IN_ROW = 10;
    private final PrivilegeChecker privilegeChecker;
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");

    @Inject
    public SyncStatusDiffRestResource(PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    public Response createSyncStatusDiff(String syncSingleUserResultString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        SyncSingleUserResult syncSingleUserResult;
        this.privilegeChecker.checkSysAdmin(request);
        if (syncSingleUserResultString == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"No syncSingleUserResultString given\"}").build();
        }
        try {
            syncSingleUserResult = (SyncSingleUserResult)JSONUtil.fromJson((String)syncSingleUserResultString, SyncSingleUserResult.class);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"Deserialse wrongD\"}").build();
        }
        if (syncSingleUserResult.getUpdateUserResult() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"No update user result in request\"}").build();
        }
        AtlasUser resultingUser = syncSingleUserResult.getUpdateUserResult().getResultingUser().orElse(null);
        if (resultingUser == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"No resulting user\"}").build();
        }
        List<SyncStatusDiffResultEntity.ResultingUserEntry> resultingUserResult = resultingUser.getAttributeKeys().stream().filter(key -> !key.equals("ATLAS_USER_TIMESTAMP")).map(key -> new SyncStatusDiffResultEntity.ResultingUserEntry(AtlasUserKeys.getNameForUi((String)key), CollectionUtil.formatAsString((Collection)resultingUser.getAttributeValues(key)))).sorted((e1, e2) -> SyncStatusDiffRestResource.sortAttributesByKeyWithCustomOrder(e1.getKey(), e2.getKey())).collect(Collectors.toList());
        Optional diffJsonOptional = syncSingleUserResult.getUpdateUserResult().getDiff();
        if (!diffJsonOptional.isPresent()) {
            return Response.ok().entity((Object)JSONUtil.asJson((Object)new SyncStatusDiffResultEntity(Collections.emptyList(), resultingUserResult))).cacheControl(ccNoCache).build();
        }
        AtlasUser initialUser = syncSingleUserResult.getUpdateUserResult().getInitialUser().orElse(null);
        if (initialUser == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"No initial user\"}").build();
        }
        JsonNode diffJson = (JsonNode)diffJsonOptional.get();
        List<SyncStatusDiffResultEntity.DiffEntry> diffResult = StreamSupport.stream(diffJson.spliterator(), false).map(node -> this.createDiffEntry(resultingUser, initialUser, (JsonNode)node)).filter(Objects::nonNull).distinct().sorted((e1, e2) -> SyncStatusDiffRestResource.sortAttributesByKeyWithCustomOrder(e1.getKey(), e2.getKey())).collect(Collectors.toList());
        return Response.ok().entity((Object)JSONUtil.asJson((Object)new SyncStatusDiffResultEntity(diffResult, resultingUserResult))).cacheControl(ccNoCache).build();
    }

    @Nullable
    private SyncStatusDiffResultEntity.DiffEntry createDiffEntry(@Nonnull AtlasUser resultingUser, @Nonnull AtlasUser initialUser, @Nonnull JsonNode node) {
        if (!node.has("op") || !node.has("path")) {
            return null;
        }
        String op = node.get("op").asText();
        String path = node.get("path").asText();
        if (path.startsWith("/reference")) {
            return null;
        }
        String[] attrArr = path.split("/");
        if (attrArr.length < 3) {
            return null;
        }
        String attr = attrArr[2];
        if (attr.equals("ATLAS_USER_TIMESTAMP")) {
            return null;
        }
        List<String> oldValues = initialUser.getAttributeValues(attr).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
        List<String> newValues = resultingUser.getAttributeValues(attr).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
        oldValues = SyncStatusDiffRestResource.truncateListWithSummary(oldValues);
        newValues = SyncStatusDiffRestResource.truncateListWithSummary(newValues);
        String oldValue = CollectionUtil.formatAsString(oldValues);
        String newValue = CollectionUtil.formatAsString(newValues);
        Set initialSet = initialUser.getAttributeValues(attr);
        Set resultingSet = resultingUser.getAttributeValues(attr);
        String addedValues = SetUtil.difference((Set)resultingSet, (Set)initialSet).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining("\n"));
        String removedValues = SetUtil.difference((Set)initialSet, (Set)resultingSet).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining("\n"));
        String unchangedValues = SetUtil.intersect((Set)initialSet, (Set)resultingSet).stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining("\n"));
        if (initialSet.size() > 1 || resultingSet.size() > 1) {
            if (!addedValues.isEmpty() && !removedValues.isEmpty()) {
                op = "ADDED and REMOVED";
            } else if (!addedValues.isEmpty()) {
                op = "ADD";
            } else if (!removedValues.isEmpty()) {
                op = "REMOVED";
            }
        }
        String style = LozengeStyle.GREY.getStyle();
        if (op.equalsIgnoreCase("REPLACE")) {
            style = LozengeStyle.ORANGE.getStyle();
        } else if (op.equalsIgnoreCase("ADD")) {
            style = LozengeStyle.GREEN.getStyle();
        } else if (op.equalsIgnoreCase("REMOVED")) {
            style = LozengeStyle.RED.getStyle();
        } else if (op.equalsIgnoreCase("ADDED and REMOVED")) {
            style = LozengeStyle.PURPLE.getStyle();
        }
        return new SyncStatusDiffResultEntity.DiffEntry(AtlasUserKeys.getNameForUi((String)attr), oldValue, newValue, op, style, initialSet.size() > 1 || resultingSet.size() > 1, String.join((CharSequence)"\n", addedValues), String.join((CharSequence)"\n", removedValues), String.join((CharSequence)"\n", unchangedValues), SyncStatusDiffRestResource.createDownloadResult(addedValues, removedValues, unchangedValues));
    }

    @Nonnull
    private static List<String> truncateListWithSummary(@Nonnull List<String> values) {
        if (values.size() > 10) {
            int oldSize = values.size();
            values = values.subList(0, 10);
            values.add(" ... and " + (oldSize - 10) + " more");
        }
        return values;
    }

    @Nonnull
    private static String createDownloadResult(@Nonnull String addedValues, @Nonnull String removedValues, @Nonnull String unchangedValues) {
        return "Added\n=====\n\n" + addedValues + "\n\n\nRemoved\n=======\n\n" + removedValues + "\n\n\nUnchanged\n========\n\n" + unchangedValues + "\n";
    }

    private static int sortAttributesByKeyWithCustomOrder(@Nonnull String key1, @Nonnull String key2) {
        List<String> order = Arrays.asList("Username", "Firstname", "Lastname", "Fullname", "Email", "Groups");
        int index1 = order.indexOf(key1);
        int index2 = order.indexOf(key2);
        if (index1 != -1 && index2 != -1) {
            return Integer.compare(index1, index2);
        }
        if (index1 != -1) {
            return -1;
        }
        if (index2 != -1) {
            return 1;
        }
        return key1.compareTo(key2);
    }
}

