/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.frontend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.LabelValue;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.api.ConnectorFactoryRegistry;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.IdentifierForSingleUserSync;
import de.resolution.usersync.frontend.UserSyncDynamicFrontendProvider;
import de.resolution.usersync.frontend.UserSyncFrontendService;
import de.resolution.usersync.rest.entities.ConnectorFactoryEntity;
import de.resolution.usersync.rest.entities.SyncSingleUserEntity;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserSyncFrontendServiceImpl
implements UserSyncFrontendService {
    private static final Logger logger = LoggerFactory.getLogger(UserSyncFrontendServiceImpl.class);
    private final ConnectorFactoryRegistry connectorFactoryRegistry;
    private final UserSyncDynamicFrontendProvider dynamicFragmentProvider;
    private final ConnectorService connectorService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public UserSyncFrontendServiceImpl(ConnectorFactoryRegistry connectorFactoryRegistry, ConnectorService connectorService) {
        this.connectorFactoryRegistry = connectorFactoryRegistry;
        this.dynamicFragmentProvider = new UserSyncDynamicFrontendProvider(connectorFactoryRegistry);
        this.connectorService = connectorService;
    }

    @Override
    public UserSyncDynamicFrontendProvider getDynamicFrontendProvider() {
        return this.dynamicFragmentProvider;
    }

    @Override
    @Nullable
    public ValidationResult validateFrontendStateFragment(String jsonString, String uiPath, String frontendStatePath) throws IOException {
        logger.debug("Validating jsonString={} \n uiPath={} , and  frontendStatePath={}", new Object[]{jsonString, uiPath, frontendStatePath});
        if (!Objects.equals(uiPath, "admin") && !Objects.equals(uiPath, "usersync") || frontendStatePath == null) {
            return null;
        }
        ValidationResult result = ValidationResult.create();
        JsonNode fragmentNode = this.objectMapper.readTree(jsonString);
        switch (frontendStatePath) {
            case "us.currentConnector": {
                return this.validateConnector(result, fragmentNode);
            }
            case "us.singleSyncModal": {
                return this.validateIdentifier(result, fragmentNode);
            }
        }
        return null;
    }

    private ValidationResult validateConnector(ValidationResult result, JsonNode fragmentNode) {
        JsonNode idNode = fragmentNode.get("uniqueId");
        if (idNode == null) {
            result.addError("Could not read uniqueId");
            return result;
        }
        String connectorUniqueId = idNode.asText();
        JsonNode typeNode = fragmentNode.get("type");
        if (typeNode != null) {
            String type = typeNode.asText();
            JsonNode configNode = fragmentNode.get("configuration");
            this.connectorService.validate(result, type, configNode, connectorUniqueId);
        } else {
            result.addError("Could not read connector type");
        }
        return result;
    }

    private ValidationResult validateIdentifier(ValidationResult result, JsonNode fragmentNode) {
        String identifierStr = "identifier";
        String syncSingleDataStr = "syncSingleData";
        JsonNode connectorIdNode = fragmentNode.get("connectorId");
        if (connectorIdNode == null) {
            result.addError("Could not read id for validating identifier");
            return result;
        }
        ValidationResult syncSingleDataNodeResult = ValidationResult.create();
        result.add("syncSingleData", syncSingleDataNodeResult);
        JsonNode syncSingleDataNode = fragmentNode.get("syncSingleData");
        if (syncSingleDataNode == null) {
            syncSingleDataNodeResult.addError("Does not contain SyncSingleData Object");
            logger.error("Validation for single user sync failed because there is no SyncSingleData object");
            return result;
        }
        JsonNode identifierNode = syncSingleDataNode.get("identifier");
        if (identifierNode == null || identifierNode.textValue() == null) {
            syncSingleDataNodeResult.add("identifier", "This field is mandatory");
        } else {
            syncSingleDataNodeResult.add("identifier", this.connectorService.validateIdentifierForSingleSync(new IdentifierForSingleUserSync(identifierNode.textValue()), connectorIdNode.asText()));
        }
        return result;
    }

    @Override
    public Map<String, Object> getConnectorDescriptions() {
        List<ConnectorFactoryEntity> connectorList = this.connectorFactoryRegistry.getRegisteredConnectorFactoryEntities();
        HashMap<String, Object> connectorDescriptions = new HashMap<String, Object>();
        connectorList.forEach(c -> {
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put("singleSyncTitle", c.getSingleSyncInputTitle());
            tmp.put("singleSyncDescription", c.getSingleSyncInputDescription());
            String connectorType = c.getConnectorClassName();
            if (!connectorDescriptions.containsKey(connectorType)) {
                connectorDescriptions.put(connectorType, tmp);
            }
        });
        return connectorDescriptions;
    }

    @Override
    public void addUserSyncFrontendState(Map<String, Object> frontendState) {
        HashMap<String, Object> usFrontendState = new HashMap<String, Object>();
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("groovyCleanupDeciderCode", "boolean shouldCleanup(AtlasUser atlasUser, long syncStartedAtTimestamp) {\n    return timestamp(atlasUser) < syncStartedAtTimestamp\n}");
        defaults.put("disableNotFoundLookupTransformation", (String)AttributeTransformationConfig.create((String)"identifier"));
        usFrontendState.put("defaults", defaults);
        List visibleFactoryList = this.connectorFactoryRegistry.getRegisteredConnectorFactoryEntities().stream().filter(ConnectorFactoryEntity::isVisible).map(factory -> new LabelValue<String>(factory.getName(), factory.getConnectorClassName())).collect(Collectors.toList());
        usFrontendState.put("availableFactories", visibleFactoryList);
        usFrontendState.put("visibleAvailableFactories", visibleFactoryList);
        List factoryListIncludingInvisible = this.connectorFactoryRegistry.getRegisteredConnectorFactoryEntities().stream().map(factory -> new LabelValue<String>(factory.getName(), factory.getConnectorClassName())).collect(Collectors.toList());
        usFrontendState.put("allAvailableFactories", factoryListIncludingInvisible);
        usFrontendState.put("reloadConnectorList", false);
        usFrontendState.put("syncSingleData", new SyncSingleUserEntity("", StructuredData.create(), null, false));
        frontendState.put("us", usFrontendState);
    }
}

