/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import de.resolution.commons.data.ListStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.builtin.scim.ScimConnector;
import de.resolution.usersync.builtin.scim.rest.AbstractResource;
import de.resolution.usersync.builtin.scim.rest.ListResponse;
import de.resolution.usersync.builtin.scim.rest.PATCH;
import de.resolution.usersync.builtin.scim.rest.PatchRequest;
import de.resolution.usersync.builtin.scim.rest.ScimErrorResponseBuilder;
import de.resolution.usersync.builtin.scim.rest.ScimRequestUtils;
import de.resolution.usersync.builtin.scim.user.ScimCoreUser;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="usersync/connector/{connectorId}/scim/v2/Users")
@AnonymousAllowed
public class UserResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);
    private static final String PATH_PARAM_USER_ID = "userId";
    private static final String MESSAGE_USER_ID_MUST_NOT_BE_EMPTY = "UserId must not be empty";

    @Autowired
    public UserResource(ConnectorService connectorService, PrivilegeChecker privilegeChecker, LicenseChecker licenseChecker) {
        super(connectorService, privilegeChecker, licenseChecker);
    }

    @GET
    @Produces(value={"application/json", "application/scim+json"})
    public Response getUsers(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @QueryParam(value="startIndex") int startIndex, @QueryParam(value="count") int count, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @QueryParam(value="filter") @Nullable String filter) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        ListResponse listResponse = scimConnector.getUsers(ScimRequestUtils.parseStartIndex(startIndex), ScimRequestUtils.parseCount(count), ScimRequestUtils.parseFilter(filter), ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes));
        return Response.ok((Object)JSONUtil.asJson((Object)listResponse)).build();
    }

    @GET
    @Path(value="/{userId}")
    @Produces(value={"application/json", "application/scim+json"})
    public Response getUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="userId") @Nullable String userId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (userId == null || userId.isEmpty()) {
            throw new BadRequestException(MESSAGE_USER_ID_MUST_NOT_BE_EMPTY, "noTarget");
        }
        ScimCoreUser scimUser = scimConnector.getUser(userId, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes));
        return Response.ok((Object)JSONUtil.asJson((Object)scimUser)).build();
    }

    @POST
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response createUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @Nullable String resourceString) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (resourceString == null) {
            return new ScimErrorResponseBuilder().status(Response.Status.BAD_REQUEST).detail("request contains no resource string").build();
        }
        StructuredData data = StructuredData.parseJson((String)resourceString);
        ScimCoreUser createdUser = scimConnector.createOrUpdateUser(data, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes));
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)JSONUtil.asJson((Object)createdUser)).build();
    }

    @PUT
    @Path(value="{userId}")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response updateUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="userId") @Nullable String userId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @Nullable String resourceString) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (userId == null || userId.isEmpty()) {
            throw new BadRequestException(MESSAGE_USER_ID_MUST_NOT_BE_EMPTY, "noTarget");
        }
        if (resourceString == null) {
            return new ScimErrorResponseBuilder().status(Response.Status.BAD_REQUEST).detail("request contains no resource string").build();
        }
        StructuredData data = StructuredData.parseJson((String)resourceString);
        ScimCoreUser updatedUser = scimConnector.updateUser(userId, data, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)JSONUtil.asJson((Object)updatedUser)).build();
    }

    @PATCH
    @Path(value="{userId}")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response patchUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="userId") @Nullable String userId, @QueryParam(value="attributes") @Nullable String attributes, @QueryParam(value="excludedAttributes") @Nullable String excludedAttributes, @Nullable String resourceString) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (userId == null || userId.isEmpty()) {
            throw new BadRequestException(MESSAGE_USER_ID_MUST_NOT_BE_EMPTY, "noTarget");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("PATCH user {}: {}", (Object)StringUtil.sanitize((String)userId), (Object)StringUtil.sanitize((String)resourceString));
        }
        if (resourceString == null || resourceString.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("PATCH operation for user {} did not contain PATCH operations", (Object)StringUtil.sanitize((String)userId));
            }
            return Response.notModified().build();
        }
        PatchRequest patchRequest = PatchRequest.fromJson(resourceString);
        HashMap<String, Object> attributesToUpdate = new HashMap<String, Object>();
        HashSet<StructuredData> groupsToAdd = new HashSet<StructuredData>();
        HashSet<StructuredData> groupsToRemove = new HashSet<StructuredData>();
        HashSet<StructuredData> groupsToReplace = new HashSet<StructuredData>();
        block9: for (PatchRequest.PatchOperation operation : patchRequest.getOperations()) {
            if ("groups".equalsIgnoreCase(operation.getPath())) {
                switch (operation.getOp()) {
                    case ADD: {
                        StructuredData value = operation.getValue();
                        if (value.isList()) {
                            groupsToAdd.addAll((Collection<StructuredData>)value.asList());
                            continue block9;
                        }
                        groupsToAdd.add(value);
                        continue block9;
                    }
                    case REPLACE: {
                        StructuredData value = operation.getValue();
                        if (value.isList()) {
                            groupsToReplace.addAll((Collection<StructuredData>)value.asList());
                            continue block9;
                        }
                        groupsToReplace.add(value);
                        continue block9;
                    }
                    case REMOVE: {
                        StructuredData value = operation.getValue();
                        if (value.isList()) {
                            groupsToRemove.addAll((Collection<StructuredData>)value.asList());
                            continue block9;
                        }
                        groupsToRemove.add(value);
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + (Object)((Object)operation.getOp()));
                    }
                }
            }
            switch (operation.getOp()) {
                case ADD: 
                case REPLACE: {
                    attributesToUpdate.put(operation.getPath(), operation.getValue());
                    continue block9;
                }
                case REMOVE: {
                    attributesToUpdate.put(operation.getPath(), StructuredData.create());
                    continue block9;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)operation.getOp()));
        }
        if (!CollectionUtil.isNullOrEmpty(groupsToReplace)) {
            attributesToUpdate.put("groups", new ListStructuredData(groupsToReplace));
        }
        ScimCoreUser updatedUser = scimConnector.patchUser(userId, (StructuredData)StructuredData.create(attributesToUpdate), groupsToAdd, groupsToRemove, ScimRequestUtils.parseMultiValuedAttributes(attributes), ScimRequestUtils.parseMultiValuedAttributes(excludedAttributes));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)JSONUtil.asJson((Object)updatedUser)).build();
    }

    @DELETE
    @Path(value="/{userId}")
    @Produces(value={"application/json", "application/scim+json"})
    public Response deleteUser(@Context @Nonnull HttpServletRequest request, @PathParam(value="connectorId") @Nullable String connectorId, @PathParam(value="userId") @Nullable String userId) throws ScimException {
        ScimConnector scimConnector = this.checkPrivilegesAndGetConnector(request, connectorId);
        if (userId == null || userId.isEmpty()) {
            throw new BadRequestException(MESSAGE_USER_ID_MUST_NOT_BE_EMPTY, "noTarget");
        }
        scimConnector.deleteUser(userId);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/.search")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/json", "application/scim+json"})
    public Response getUsersByPost(String resourceString) throws ScimException {
        throw new NotImplementedException("This endpoint is not implemented");
    }
}

