/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.ErrorResponse;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.builtin.scim.rest.ScimErrorResponseBuilder;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ScimExceptionMapper
implements ExceptionMapper<ScimException> {
    private static final Logger logger = LoggerFactory.getLogger(ScimExceptionMapper.class);

    public Response toResponse(ScimException e) {
        ErrorResponse scimError = e.getScimError();
        ScimErrorResponseBuilder builder = new ScimErrorResponseBuilder().status(scimError.getStatus()).detail(e.getMessage());
        if (!StringUtil.isNullOrEmpty((String)scimError.getScimType())) {
            builder.scimType(scimError.getScimType());
        }
        if (e instanceof ResourceNotFoundException) {
            if (logger.isDebugEnabled()) {
                logger.debug("SCIM request failed: " + e.getMessage() + ", errorType: " + JSONUtil.asJson((Object)e.getScimError()), (Throwable)e);
            }
        } else if (logger.isErrorEnabled()) {
            logger.error("SCIM request failed: " + e.getMessage() + ", errorType: " + JSONUtil.asJson((Object)e.getScimError()), (Throwable)e);
        }
        return builder.build();
    }
}

