/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.disableInactive;

import de.resolution.atlasuser.api.AtlasUserStatusObject;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserFunction;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.task.api.Task;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.builtin.disableInactive.CleanupInactiveUsersFunction;
import de.resolution.usersync.builtin.disableInactive.DisableInactiveConnectorConfiguration;
import de.resolution.usersync.spi.AbstractConnector;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisableInactiveUsersConnector
extends AbstractConnector<DisableInactiveConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(DisableInactiveUsersConnector.class);

    public DisableInactiveUsersConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull DisableInactiveConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/empty.json");
    }

    @Override
    public void sync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatus syncStatus) {
        AtlasUserAdapter atlasUserAdapter = syncFunction.getAtlasUserAdapter();
        if (!this.isValid()) {
            syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
            syncStatus.addMessage("Connector is not valid or unconfigured, cannot start sync");
            syncStatus.setStatus(Task.Status.DONE);
            return;
        }
        CleanupInactiveUsersFunction cleanupInactiveUsersFunction = new CleanupInactiveUsersFunction(((DisableInactiveConnectorConfiguration)this.configuration).getMaxDurationSinceLastLogin(), atlasUserAdapter, syncStatus, ((DisableInactiveConnectorConfiguration)this.configuration).isDisableUsersWithoutTimestamp(), ((DisableInactiveConnectorConfiguration)this.configuration).getGroupWhitelist(), ((DisableInactiveConnectorConfiguration)this.configuration).getCleanupBehaviour(), ((DisableInactiveConnectorConfiguration)this.configuration).isRemoveAllGroupAssignmentsOnCleanup(), ((DisableInactiveConnectorConfiguration)this.configuration).getGroupsOrRegexNotBeRemoved());
        syncStatus.setStatus(Task.Status.RUNNING);
        syncStatus.setSyncStatusResult(SyncStatus.Result.PENDING);
        try {
            logger.debug("Calling ApplyToAll");
            atlasUserAdapter.applyToAll(((DisableInactiveConnectorConfiguration)this.configuration).getDirectoryId(), (AtlasUserFunction)cleanupInactiveUsersFunction, (AtlasUserStatusObject)syncStatus, null);
            syncStatus.setStatus(Task.Status.DONE);
            if (syncStatus.getSyncStatusResult() != SyncStatus.Result.FAILED && syncStatus.getSyncStatusResult() != SyncStatus.Result.PARTIALLY_FAILED) {
                syncStatus.setSyncStatusResult(SyncStatus.Result.SUCCESS);
            }
        }
        catch (Exception e) {
            syncStatus.addMessage("Error while disabling users: " + e.getMessage());
            logger.error("CleanupConnector failed", (Throwable)e);
            syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
            syncStatus.setStatus(Task.Status.DONE);
        }
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        syncStatusFacade.fail("doSync() is not implemented and should never be called.", logger);
    }

    @Override
    public boolean isCanSyncSingleUser() {
        return false;
    }

    @Override
    public boolean isCleanupConfigurable() {
        return false;
    }

    @Override
    public boolean isAllowCustomAttributeMapping() {
        return false;
    }

    @Override
    public boolean isSelectableDirectory() {
        return true;
    }

    @Override
    public boolean isAllowSelectingFindByAttribute() {
        return false;
    }

    @Override
    public boolean isAllowGroupConfiguration() {
        return false;
    }

    @Override
    public boolean isCanCopyUsers() {
        return false;
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        return FindUserResult.failed("Not implemented");
    }

    @Override
    @Nonnull
    public Class<DisableInactiveConnectorConfiguration> getConfigurationClass() {
        return DisableInactiveConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Cleanup Inactive Users";
    }

    @Override
    public List<String> getConnectorAttributes() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return false;
    }

    @Override
    public boolean isCanHaveRequiredGroups() {
        return false;
    }

    @Override
    public boolean isHasProvisioningSettings() {
        return false;
    }

    @Override
    public boolean isAllowCreatingNewDirectory() {
        return false;
    }
}

