/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api.exception;

import javax.annotation.Nullable;

public class RequestFailedException
extends Exception {
    public static final int NOT_FOUND = 404;
    public static final int OK = 200;
    public static final int NO_STATUS_CODE = -1;
    private final int statusCode;
    private final String statusMessage;
    private final String bodyString;

    public RequestFailedException(Throwable cause) {
        super(cause);
        this.statusCode = -1;
        this.statusMessage = null;
        this.bodyString = null;
    }

    public RequestFailedException(String message) {
        this(message, -1, null, null);
    }

    public RequestFailedException(String message, Throwable cause) {
        super(message, cause);
        this.statusCode = -1;
        this.statusMessage = null;
        this.bodyString = null;
    }

    public RequestFailedException(int statusCode, @Nullable String statusMessage) {
        this("Request failed", statusCode, statusMessage);
    }

    public RequestFailedException(String message, int statusCode, @Nullable String statusMessage) {
        super(message + ": " + statusCode + ": " + statusMessage);
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.bodyString = null;
    }

    public RequestFailedException(String message, int statusCode, @Nullable String statusMessage, @Nullable String bodyString) {
        super(message + ": " + statusCode + ": " + statusMessage + ": " + bodyString);
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.bodyString = bodyString;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Nullable
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Nullable
    public String getBodyString() {
        return this.bodyString;
    }
}

