/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.userauth;

import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.samlwrapper.api.LogoutHandler;
import com.resolution.samlwrapper.api.LogoutPageMessage;
import com.resolution.samlwrapper.api.exception.LogoutHandlerException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractLogoutHander
implements LogoutHandler {
    protected final SamlSsoService samlSsoService;
    protected final RunningConfiguration pluginConfiguration;

    public AbstractLogoutHander(SamlSsoService samlSsoService, RunningConfiguration pluginConfiguration) {
        this.samlSsoService = samlSsoService;
        this.pluginConfiguration = pluginConfiguration;
    }

    protected abstract void doLogout(HttpServletRequest var1, HttpServletResponse var2, AuthenticationTracker var3) throws LogoutHandlerException, IOException;

    public void logout(HttpServletRequest req, HttpServletResponse resp, SAMLAuthenticationTracker tracker) throws LogoutHandlerException, IOException {
        this.doLogout(req, resp, (AuthenticationTracker)tracker);
    }

    public void logout(HttpServletRequest req, HttpServletResponse resp, SAMLAuthenticationTracker tracker, String sessionIndex, String nameId, String idpId) throws LogoutHandlerException, IOException {
        this.doLogout(req, resp, (AuthenticationTracker)tracker);
    }

    public void showLoggedOutPage(HttpServletRequest req, HttpServletResponse resp, SAMLAuthenticationTracker tracker, List<LogoutPageMessage> messages) throws ServletException, IOException {
        String logoutUrl = this.pluginConfiguration.getLogoutUrl();
        if (logoutUrl != null && !logoutUrl.trim().isEmpty()) {
            resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
            resp.sendRedirect(logoutUrl);
            return;
        }
        String messagesUrlParameters = "";
        if (messages != null && !messages.isEmpty()) {
            messagesUrlParameters = "?logoutPageMessageType=" + URLEncoder.encode(messages.get(0).getMessageType(), "UTF-8") + "&logoutPageMessage=" + URLEncoder.encode(messages.get(0).getMessage(), "UTF-8");
        }
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        resp.sendRedirect(this.samlSsoService.getRelativeLoggedOutPageUrl() + messagesUrlParameters);
    }
}

