/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.oidcandoauth.oidc;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class Nonce {
    private static final Random random = new SecureRandom();

    private Nonce() {
    }

    @Nonnull
    private static Stream<Character> getRandomAlphabets(int count, boolean upperCase) {
        IntStream characters = null;
        characters = upperCase ? random.ints(count, 65, 90) : random.ints(count, 97, 122);
        return characters.mapToObj(data -> Character.valueOf((char)data));
    }

    private static Stream<Character> getRandomNumbers(int count) {
        IntStream numbers = random.ints(count, 48, 57);
        return numbers.mapToObj(data -> Character.valueOf((char)data));
    }

    @Nonnull
    public static String create() {
        Stream<Character> pwdStream = Stream.concat(Nonce.getRandomNumbers(3), Stream.concat(Nonce.getRandomAlphabets(6, true), Nonce.getRandomAlphabets(6, false)));
        List charList = pwdStream.collect(Collectors.toList());
        Collections.shuffle(charList);
        return charList.stream().collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
    }
}

