/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import de.resolution.commons.validate.api.ValidationResult;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@JsonAutoDetect
public class MultiIdPMetadataMergeResult {
    private final String message;
    private final ConfigurationData configurationData;
    private final ValidationResult validationResult;
    private final List<String> changedIds;
    private final List<String> addedIds;
    private final List<String> removedIds;

    public MultiIdPMetadataMergeResult(ConfigurationData configurationData, ValidationResult validationResult, String message, @Nonnull List<String> changedIds, @Nonnull List<String> addedIds, @Nonnull List<String> removedIds) {
        this.configurationData = configurationData;
        this.validationResult = validationResult;
        this.message = message;
        this.changedIds = changedIds;
        this.addedIds = addedIds;
        this.removedIds = removedIds;
    }

    public static MultiIdPMetadataMergeResult createdUnchanged(ConfigurationData configurationData, String message) {
        return new MultiIdPMetadataMergeResult(configurationData, ValidationResult.create(), message, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public String getMessage() {
        return this.message;
    }

    public ConfigurationData getConfigurationData() {
        return this.configurationData;
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public boolean isChanged() {
        return !this.changedIds.isEmpty() || !this.addedIds.isEmpty() || !this.removedIds.isEmpty();
    }

    public int getChangedCount() {
        return this.changedIds.size();
    }

    public int getAddedCount() {
        return this.addedIds.size();
    }

    public int getRemovedCount() {
        return this.removedIds.size();
    }

    public List<String> getChangedIds() {
        return this.changedIds;
    }

    public List<String> getAddedIds() {
        return this.addedIds;
    }

    public List<String> getRemovedIds() {
        return this.removedIds;
    }
}

