/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.resolution.atlasplugins.samlsso.Defaults;
import com.resolution.atlasplugins.samlsso.JiraServiceDeskDetector;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.samlwrapper.api.metadata.impl.MetadataInformationImpl;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationDefaultSetter {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationDefaultSetter.class);
    private final ApplicationProperties applicationProperties;
    private final DirectoryAdapter directoryAdapter;
    private final JiraServiceDeskDetector jiraServiceDeskDetector;

    public ConfigurationDefaultSetter(ApplicationProperties applicationProperties, DirectoryAdapter directoryAdapter, JiraServiceDeskDetector jiraServiceDeskDetector) {
        this.applicationProperties = applicationProperties;
        this.directoryAdapter = directoryAdapter;
        this.jiraServiceDeskDetector = jiraServiceDeskDetector;
    }

    public void addSamlDefaults(ConfigurationData configurationData, boolean newConfig) {
        if (configurationData.idpConfigurations != null) {
            for (CommonIdpConfigurationData idpConfig : configurationData.idpConfigurations) {
                if (!(idpConfig instanceof SamlIdpConfigurationData)) continue;
                this.addSamlDefaults((SamlIdpConfigurationData)idpConfig);
            }
        }
        if (configurationData.sessionCookieName == null || configurationData.sessionCookieName.isEmpty()) {
            configurationData.sessionCookieName = this.getSessionIdCookieName();
        }
        if (configurationData.defaultRedirectUrl == null || configurationData.defaultRedirectUrl.trim().isEmpty()) {
            configurationData.defaultRedirectUrl = "/";
        }
        if (configurationData.loggedInPageTemplate == null || configurationData.loggedInPageTemplate.trim().isEmpty()) {
            logger.info("Setting loggedInPageTempate to default");
            configurationData.loggedInPageTemplate = Defaults.DEFAULT_LOGGEDINPAGETEMPLATE;
        }
        if (configurationData.loggedOutPageTemplate == null || configurationData.loggedOutPageTemplate.trim().isEmpty()) {
            logger.info("Setting loggedOutPageTempate to default");
            configurationData.loggedOutPageTemplate = Defaults.DEFAULT_LOGGEDOUTPAGETEMPLATE;
        }
        if (configurationData.errorPageTemplate == null || configurationData.errorPageTemplate.trim().isEmpty()) {
            logger.info("Setting errorPageTempate to default");
            configurationData.errorPageTemplate = Defaults.DEFAULT_ERRORPAGETEMPLATE;
        }
        if (configurationData.idpSelectionPageTemplate == null || configurationData.idpSelectionPageTemplate.trim().isEmpty()) {
            logger.info("Setting idpSelectionPageTemplate to default");
            configurationData.idpSelectionPageTemplate = Defaults.DEFAULT_IDPSELECTIONPAGETEMPLATE;
        }
        if (configurationData.serviceDeskErrorPageTemplate == null || configurationData.serviceDeskErrorPageTemplate.trim().isEmpty()) {
            logger.info("Setting serviceDeskErrorPageTemplate to default");
            configurationData.serviceDeskErrorPageTemplate = Defaults.DEFAULT_SERVICEDESK_ERRORPAGETEMPLATE;
        }
        if (configurationData.idpByEmailPageTemplate == null || configurationData.idpByEmailPageTemplate.trim().isEmpty()) {
            logger.info("Setting idpByEmailPageTemplate to default");
            configurationData.idpByEmailPageTemplate = Defaults.DEFAULT_IDP_BY_EMAIL_PAGETEMPLATE;
        }
        if (configurationData.idpByEmailPageJavaScript == null || configurationData.idpByEmailPageJavaScript.trim().isEmpty()) {
            logger.info("Setting idpByEmailPageJavaScript to default");
            configurationData.idpByEmailPageJavaScript = Defaults.DEFAULT_IDP_BY_EMAIL_JAVASCRIPT;
        }
        if (configurationData.metadataInformation == null) {
            configurationData.metadataInformation = new MetadataInformationImpl();
        }
        if (configurationData.entityId == null || configurationData.entityId.trim().isEmpty()) {
            configurationData.entityId = this.getDefaultEntityId();
            logger.info("Entity Id is not set, using {}", (Object)configurationData.entityId);
        }
        if (newConfig && configurationData.nonSsoUserAgents.isEmpty()) {
            logger.info("Setting nonSsoUserAgents to default {}", (Object)"Jakarta Commons-HttpClient,ms-office,Microsoft Office");
            configurationData.nonSsoUserAgents = this.getDefaultNonSsoUserAgents();
        }
        if (configurationData.idpNameFromMetadataExpression == null || configurationData.idpNameFromMetadataExpression.trim().isEmpty()) {
            configurationData.idpNameFromMetadataExpression = "md.data\n    ?.'md:EntityDescriptor'?._value\n    ?.'md:IDPSSODescriptor'?._value\n    ?.'md:Extensions'\n    ?.'mdui:UIInfo'?._value\n    ?.'mdui:DisplayName'?._value\n    ?.getAt(0)\n    ?: \"IdP $id\"";
        }
    }

    public String getDefaultEntityId() {
        return this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/plugins/servlet/samlsso";
    }

    public ConfigurationData clearSamlDefaults(ConfigurationData configurationDataToClear) {
        ConfigurationData configurationData = new ConfigurationData(configurationDataToClear);
        if (configurationData.idpConfigurations != null) {
            for (CommonIdpConfigurationData idpConfig : configurationData.idpConfigurations) {
                if (!(idpConfig instanceof SamlIdpConfigurationData)) continue;
                this.clearSamlDefaults((SamlIdpConfigurationData)idpConfig);
            }
        }
        if (configurationData.defaultRedirectUrl != null && configurationData.defaultRedirectUrl.equals("/")) {
            logger.debug("defaultRedirectUrl is default, clearing");
            configurationData.defaultRedirectUrl = null;
        }
        if (configurationData.loggedInPageTemplate != null && configurationData.loggedInPageTemplate.equals(Defaults.DEFAULT_LOGGEDINPAGETEMPLATE)) {
            logger.debug("loggedInPageTemplate is default, clearing");
            configurationData.loggedInPageTemplate = null;
        }
        if (configurationData.loggedOutPageTemplate != null && configurationData.loggedOutPageTemplate.equals(Defaults.DEFAULT_LOGGEDOUTPAGETEMPLATE)) {
            logger.debug("loggedOutPageTemplate is default, clearing");
            configurationData.loggedOutPageTemplate = null;
        }
        if (configurationData.errorPageTemplate != null && configurationData.errorPageTemplate.equals(Defaults.DEFAULT_ERRORPAGETEMPLATE)) {
            logger.debug("errorPageTemplate is default, clearing");
            configurationData.errorPageTemplate = null;
        }
        if (configurationData.idpSelectionPageTemplate != null && configurationData.idpSelectionPageTemplate.equals(Defaults.DEFAULT_IDPSELECTIONPAGETEMPLATE)) {
            logger.debug("idpSelectionPageTemplate is default, clearing");
            configurationData.idpSelectionPageTemplate = null;
        }
        if (configurationData.serviceDeskErrorPageTemplate != null && configurationData.serviceDeskErrorPageTemplate.equals(Defaults.DEFAULT_SERVICEDESK_ERRORPAGETEMPLATE)) {
            logger.debug("serviceDeskErrorPageTemplate is default, clearing");
            configurationData.serviceDeskErrorPageTemplate = null;
        }
        if (configurationData.idpByEmailPageTemplate != null && configurationData.idpByEmailPageTemplate.equals(Defaults.DEFAULT_IDP_BY_EMAIL_PAGETEMPLATE)) {
            logger.debug("idpByEmailPageTemplate is default, clearing");
            configurationData.idpByEmailPageTemplate = null;
        }
        if (configurationData.idpByEmailPageJavaScript != null && configurationData.idpByEmailPageJavaScript.equals(Defaults.DEFAULT_IDP_BY_EMAIL_JAVASCRIPT)) {
            logger.debug("idpByEmailPageJavaScript is default, clearing");
            configurationData.idpByEmailPageJavaScript = null;
        }
        return configurationData;
    }

    public void addSamlDefaults(SamlIdpConfigurationData idpConfig) {
        if (idpConfig.relayStateParameterName == null || idpConfig.relayStateParameterName.trim().isEmpty()) {
            logger.debug("Setting RelayState parameter name to default {}", (Object)"RelayState");
            idpConfig.relayStateParameterName = "RelayState";
        }
        if (idpConfig.directoryIdForNewUsers == null || idpConfig.directoryIdForNewUsers.equals(1L)) {
            logger.debug("Setting directoryIdForNewUsers to default {}", (Object)this.directoryAdapter.getLowestDirectoryId());
            idpConfig.directoryIdForNewUsers = this.directoryAdapter.getLowestDirectoryId();
        }
        if (idpConfig.attributeTransformations == null) {
            idpConfig.attributeTransformations = new ArrayList();
        }
        if (this.containsNoSystemMapping("ATTR_NAME", idpConfig.attributeTransformations)) {
            idpConfig.attributeTransformations.add(AttributeTransformationConfig.createRequired((Source)Source.createSingle((String)"ATTR_NAMEID"), (Target)new Target(Target.Type.SYSTEM, "ATTR_NAME")));
        }
        if (this.containsNoSystemMapping("ATTR_FULLNAME", idpConfig.attributeTransformations)) {
            idpConfig.attributeTransformations.add(AttributeTransformationConfig.createRequired((Target)Target.createSystem((String)"ATTR_FULLNAME")));
        }
        if (this.containsNoSystemMapping("ATTR_EMAIL", idpConfig.attributeTransformations)) {
            idpConfig.attributeTransformations.add(AttributeTransformationConfig.createRequired((Target)Target.createSystem((String)"ATTR_EMAIL")));
        }
        if (this.containsNoSystemMapping("ATTR_GROUPS", idpConfig.attributeTransformations)) {
            idpConfig.attributeTransformations.add(AttributeTransformationConfig.createRequired((Target)Target.createSystem((String)"ATTR_GROUPS")));
        }
        if (this.jiraServiceDeskDetector.isJiraServiceDesk() && this.containsNoSystemMapping("JIRA.ATTR_ORGANIZATIONS", idpConfig.attributeTransformations)) {
            idpConfig.attributeTransformations.add(AttributeTransformationConfig.createRequired((Target)Target.createSystem((String)"JIRA.ATTR_ORGANIZATIONS")));
        }
    }

    public void addOidcAndOAuthDefaults(OAuth2IdpConfigurationData idpConfig) {
        if (idpConfig.attributeTransformations == null) {
            idpConfig.attributeTransformations = new ArrayList();
        }
        if (this.containsNoSystemMapping("ATTR_NAME", idpConfig.attributeTransformations)) {
            idpConfig.attributeTransformations.add(AttributeTransformationConfig.createRequired((Target)Target.createSystem((String)"ATTR_NAME")));
        }
        if (this.containsNoSystemMapping("ATTR_EMAIL", idpConfig.attributeTransformations)) {
            idpConfig.attributeTransformations.add(AttributeTransformationConfig.createRequired((Target)Target.createSystem((String)"ATTR_EMAIL")));
        }
    }

    private boolean containsNoSystemMapping(String targetAttributeName, List<AttributeTransformationConfig> attributeTransformationConfigs) {
        return attributeTransformationConfigs.stream().noneMatch(trans -> trans.getTarget().getType() == Target.Type.SYSTEM && Objects.equals(trans.getTarget().getName(), targetAttributeName));
    }

    private void clearSamlDefaults(SamlIdpConfigurationData idpConfig) {
        if (idpConfig.relayStateParameterName != null && idpConfig.relayStateParameterName.equals("RelayState")) {
            logger.debug("relayStateParameterName is default, clearing it");
            idpConfig.relayStateParameterName = null;
        }
    }

    public String getSessionIdCookieName() {
        return "JSESSIONID";
    }

    @NotNull
    public List<String> getDefaultEnforceSsoUrls() {
        return Collections.emptyList();
    }

    @NotNull
    public List<String> getDefaultNonSsoUrls() {
        return Collections.emptyList();
    }

    @NotNull
    public List<String> getDefaultNonSsoUserAgents() {
        return Utils.splitString("Jakarta Commons-HttpClient,ms-office,Microsoft Office");
    }
}

