/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import de.resolution.usersync.api.LabelValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.CacheControl;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final ObjectMapper om = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    public static final String CC_NO_CACHE_VALUE = "no-cache, no-store, must-revalidate";
    public static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");

    private Utils() {
    }

    @Nullable
    public static String getDomainPartFromEmailAddress(@Nullable String emailAddress) {
        if (emailAddress == null) {
            return null;
        }
        if (!emailAddress.contains("@")) {
            return emailAddress;
        }
        String[] splitted = emailAddress.split("@");
        return splitted[splitted.length - 1];
    }

    public static List<String> splitString(String string) {
        ArrayList<String> ret;
        if (string == null || string.trim().isEmpty()) {
            ret = new ArrayList<String>();
        } else {
            String[] splitted;
            ret = new ArrayList();
            for (String s : splitted = string.split(",")) {
                if (s.trim().isEmpty()) continue;
                ret.add(s.trim());
            }
        }
        return ret;
    }

    public static String unescapeHTML(String htmlString) {
        return StringEscapeUtils.unescapeHtml((String)htmlString);
    }

    public static String join(List<? extends Object> stringList, String delimiter, String surroundWith) {
        if (stringList == null) {
            return null;
        }
        if (stringList.isEmpty()) {
            return "";
        }
        if (surroundWith == null) {
            surroundWith = "";
        }
        if (stringList.size() == 1) {
            StringBuilder sb = new StringBuilder();
            sb.append(surroundWith);
            sb.append(stringList.get(0).toString());
            sb.append(surroundWith);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(surroundWith);
        sb.append(stringList.get(0));
        sb.append(surroundWith);
        for (int i = 1; i < stringList.size(); ++i) {
            if (delimiter != null) {
                sb.append(delimiter);
            }
            sb.append(surroundWith);
            sb.append(stringList.get(i).toString());
            sb.append(surroundWith);
        }
        return sb.toString();
    }

    public static String truncate(String value, int length) {
        if (value == null || value.isEmpty() || length < 1 || value.length() <= length) {
            return value;
        }
        String ret = value.substring(0, length - 1);
        logger.warn("Truncating {} to {}", (Object)value, (Object)length);
        return ret;
    }

    public static String nullForEmpty(String value) {
        if (value != null && value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    public static String createIntendedJson(Object data) throws IOException {
        return om.writeValueAsString(data);
    }

    public static String asJson(Object data) throws JsonProcessingException {
        return om.writeValueAsString(data);
    }

    public static String asJsonString(Object data) {
        try {
            return Utils.asJson(data);
        }
        catch (JsonProcessingException e) {
            return e.getMessage();
        }
    }

    public static boolean containsIgnoreCase(Iterable<String> iterable, String string) {
        if (iterable == null || string == null) {
            return false;
        }
        for (String element : iterable) {
            if (!element.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> createMessageForJson(String msg) {
        return Collections.singletonMap("message", msg == null ? "" : msg);
    }

    public static <L, V> Map<L, V> asMap(List<LabelValue<L, V>> labelValueList) {
        HashMap ret = new HashMap();
        if (labelValueList == null) {
            return ret;
        }
        labelValueList.forEach(item -> ret.put(item.getLabel(), item.getValue()));
        return ret;
    }

    public static Map<String, Object> reduceTracker(@Nonnull AuthenticationTracker tracker, @Nonnull String absoluteBaseUrl) {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("trackerId", tracker.getTrackerId());
        toReturn.put("created", tracker.getCreated());
        toReturn.put("lastModified", tracker.getLastModified());
        toReturn.put("originalUrl", tracker.getOriginalUrl());
        toReturn.put("userId", tracker.getUserId());
        toReturn.put("status", tracker.getStatus());
        toReturn.put("samlStatus", tracker.getSamlStatus());
        toReturn.put("samlRequestId", tracker.getSamlRequestId());
        toReturn.put("exceptionInfos", tracker.getExceptionInfos());
        toReturn.put("trackerDownloadLink", absoluteBaseUrl + "/rest/samlsso-admin/1.0/reconfigure/supportinformation/admin?idList=" + tracker.getTrackerId());
        return toReturn;
    }
}

