function checkForRemovedLinchpinAttribute(frontendState, config, pathToMapping, displayNames) {

    if (pathToMapping === null || frontendState === null || displayNames === null){
        console.error("At least one argument is not given.")
        return null;
    }

    let notExistingLinchpinAttributes = null;

    if (pathToMapping.startsWith("frontendState.")){
        pathToMapping = pathToMapping.replace("frontendState.", "");
        notExistingLinchpinAttributes = _.get(frontendState, pathToMapping, []).filter(function (mapping) {
            return mapping.target.type === "LINCHPIN" && !displayNames.target.name.hasOwnProperty(mapping.target.name)
        })
    } else if (pathToMapping.startsWith("config.")){
        pathToMapping = pathToMapping.replace("config.", "");
        notExistingLinchpinAttributes = _.get(config, pathToMapping, []).filter(function (mapping) {
            return mapping.target.type === "LINCHPIN" && !displayNames.target.name.hasOwnProperty(mapping.target.name)
        })
    } else {
        return null;
    }


    if (_.isEmpty(notExistingLinchpinAttributes)) {
        return null;
    }

    return notExistingLinchpinAttributes.map(function (mapping) {
        return "Linchpin: " + mapping.target.name
    }).join(", ");
}
