/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class SyncStatusDiffResultEntity {
    private final List<DiffEntry> diff;
    private final List<ResultingUserEntry> resultingUser;

    public SyncStatusDiffResultEntity(List<DiffEntry> diff, List<ResultingUserEntry> resultingUser) {
        this.diff = diff;
        this.resultingUser = resultingUser;
    }

    @JsonProperty(value="diff")
    public List<DiffEntry> getDiff() {
        return this.diff;
    }

    @JsonProperty(value="resultingUser")
    public List<ResultingUserEntry> getResultingUser() {
        return this.resultingUser;
    }

    public static class ResultingUserEntry {
        private final String key;
        private final String value;

        public ResultingUserEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @JsonProperty(value="key")
        public String getKey() {
            return this.key;
        }

        @JsonProperty(value="value")
        public String getValue() {
            return this.value;
        }
    }

    public static class DiffEntry {
        private final String key;
        private final String old;
        private final String newValue;
        private final String operation;
        private final String style;
        private final boolean isMultiValue;
        private final String addedValues;
        private final String removedValues;
        private final String unchangedValues;
        private final String downloadResults;

        public DiffEntry(String key, String old, String newValue, String operation, String style, boolean isMultiValue, String addedValues, String removedValues, String unchangedValues, String downloadResults) {
            this.key = key;
            this.old = old;
            this.newValue = newValue;
            this.operation = operation;
            this.style = style;
            this.isMultiValue = isMultiValue;
            this.addedValues = addedValues;
            this.removedValues = removedValues;
            this.unchangedValues = unchangedValues;
            this.downloadResults = downloadResults;
        }

        @JsonProperty(value="key")
        public String getKey() {
            return this.key;
        }

        @JsonProperty(value="old")
        public String getOld() {
            return this.old;
        }

        @JsonProperty(value="new")
        public String getNewValue() {
            return this.newValue;
        }

        @JsonProperty(value="op")
        public String getOperation() {
            return this.operation;
        }

        @JsonProperty(value="style")
        public String getStyle() {
            return this.style;
        }

        @JsonProperty(value="isMultiValue")
        public boolean isMultiValue() {
            return this.isMultiValue;
        }

        @JsonProperty(value="addedValues")
        public String getAddedValues() {
            return this.addedValues;
        }

        @JsonProperty(value="removedValues")
        public String getRemovedValues() {
            return this.removedValues;
        }

        @JsonProperty(value="unchangedValues")
        public String getUnchangedValues() {
            return this.unchangedValues;
        }

        @JsonProperty(value="downloadResults")
        public String getDownloadResults() {
            return this.downloadResults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffEntry diffEntry = (DiffEntry)o;
            return this.isMultiValue == diffEntry.isMultiValue && Objects.equals(this.key, diffEntry.key) && Objects.equals(this.old, diffEntry.old) && Objects.equals(this.newValue, diffEntry.newValue) && Objects.equals(this.operation, diffEntry.operation) && Objects.equals(this.style, diffEntry.style) && Objects.equals(this.addedValues, diffEntry.addedValues) && Objects.equals(this.removedValues, diffEntry.removedValues) && Objects.equals(this.unchangedValues, diffEntry.unchangedValues) && Objects.equals(this.downloadResults, diffEntry.downloadResults);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.old, this.newValue, this.operation, this.style, this.isMultiValue, this.addedValues, this.removedValues, this.unchangedValues, this.downloadResults);
        }
    }
}

