/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2RunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oauth2.OAuth2SpecificHelpers;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OAuthFlowResult;
import com.resolution.atlasplugins.samlsso.servlet.AbstractOidcAndOAuthServlet;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.atlasplugins.samlsso.userauth.AbstractLoginHandler;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OAuth2SsoServlet
extends AbstractOidcAndOAuthServlet {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2SsoServlet.class);

    @Autowired
    public OAuth2SsoServlet(AuthenticationTrackerRepository trackerRepository, SamlSsoService samlSsoService, TemplateRenderer renderer, AbstractLoginHandler loginHandler) {
        super(trackerRepository, samlSsoService, renderer, loginHandler);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.handleCommonRequest(req, resp);
        }
        catch (IOException e) {
            logger.error("Following IOException happened", (Throwable)e);
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.handleCommonRequest(req, resp);
        }
        catch (IOException e) {
            logger.error("Following IOException happened", (Throwable)e);
        }
    }

    @Override
    protected boolean configClassMatchesConfigClassForChildServlet(CommonRunningIdpConfiguration idpConfig, AuthenticationTracker tracker) {
        if (!(idpConfig instanceof OAuth2RunningIdpConfiguration)) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Found config is not of type OAuth2RunningConfiguration, but was {}", new Object[]{idpConfig.getClass()});
            tracker.setStatus(SAMLAuthenticationTracker.Status.ERROR);
            return false;
        }
        return true;
    }

    @Override
    protected OAuthFlowResult handleSpecificCodeFlow(OAuth2RunningIdpConfiguration config, String code, AuthenticationTracker tracker, String baseUrl) {
        return OAuth2SpecificHelpers.handleCodeFlow(config, code, tracker, this.samlSsoService.getAbsoluteBaseUrl());
    }
}

