/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="connectionTestRestResource")
@Path(value="/usersync/connectionTest")
public class ConnectionTestRestResource {
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final PrivilegeChecker privilegeChecker;
    private final ConnectorService connectorService;
    private final Logger logger = LoggerFactory.getLogger(ConnectionTestRestResource.class);

    @Inject
    public ConnectionTestRestResource(PrivilegeChecker privilegeChecker, ConnectorService connectorService) {
        this.privilegeChecker = privilegeChecker;
        this.connectorService = connectorService;
    }

    @Produces(value={"application/json"})
    @GET
    public Response doConnectionTest(@QueryParam(value="connectorUID") String connectorUID, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        ConnectorAndValidationResult connector;
        this.privilegeChecker.checkSysAdmin(request);
        if (connectorUID == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"You must provide the connector UID\"}").build();
        }
        try {
            connector = this.connectorService.getConnectorByUniqueId(connectorUID);
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException | ConnectorNotFoundException e) {
            this.logger.error("Could not find connector because ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)" {\"message\": \"Could not load the connector, please check the logs\"}").build();
        }
        if (!connector.getValidationResult().isValid()) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)" {\"message\": \"Cannot do connection test because connector is not valid\"}").build();
        }
        ConnectionTestResultEntity result = new ConnectionTestResultEntity(connector.getConnector().doConnectionTest());
        return Response.ok().entity((Object)JSONUtil.asJson((Object)result)).cacheControl(ccNoCache).build();
    }
}

