/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.testconnector;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.SharedHomeProvider;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.testconnector.TestConnector;
import de.resolution.usersync.builtin.testconnector.TestConnectorConfiguration;
import de.resolution.usersync.builtin.testconnector.TestConnectorConfigurationImpl;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractConnectorFactory;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="testConnectorFactory")
@JsonAutoDetect
public class TestConnectorFactory
extends AbstractConnectorFactory<TestConnector, TestConnectorConfiguration> {
    private final SharedHomeProvider sharedHomeProvider;

    @Inject
    public TestConnectorFactory(ConnectorService connectorService, SharedHomeProvider sharedHomeProvider, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
        this.sharedHomeProvider = sharedHomeProvider;
    }

    @Override
    @Nonnull
    public TestConnector create(@Nonnull TestConnectorConfiguration testConnectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new TestConnector(this.connectorService, this.atlasUserAdapter, testConnectorConfiguration, this.sharedHomeProvider, newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public TestConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        TestConnectorConfigurationImpl mutableConfig = new TestConnectorConfigurationImpl();
        mutableConfig.setName("new Testconnector");
        mutableConfig.setUniqueId(uniqueId);
        return mutableConfig;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Test Connector";
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Connector for testing purposes only";
    }

    @Override
    @Nonnull
    public Class<TestConnector> getConnectorClass() {
        return TestConnector.class;
    }

    @Override
    @Nonnull
    public Class<TestConnectorConfiguration> getConfigurationClass() {
        return TestConnectorConfiguration.class;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editTestConnector.json";
    }

    @Override
    public String getSingleSyncInputTitle() {
        return "Testconnector";
    }

    @Override
    public String getSingleSyncInputDescription() {
        return "Enter an identifier to single sync a user";
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull TestConnectorConfiguration config) {
        ValidationResult result = super.validate(config);
        if (StringUtil.isNullOrEmpty((String)config.getEmailDomain())) {
            result.add("emailDomain", "Email domain must be set.", null);
        }
        return result;
    }
}

