/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.gsuite;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.impl.user.ProfilePictureAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.api.exception.RequestFailedException;
import de.resolution.usersync.api.exception.UserRelatedSyncException;
import de.resolution.usersync.builtin.gsuite.GSuiteConnectorConfiguration;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.AbstractOAuthAuthorizationCodeConnector;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSuiteConnector
extends AbstractOAuthAuthorizationCodeConnector<GSuiteConnectorConfiguration> {
    public static final String GSUITE_ATTRIBUTE_ID = "gsuite_ID";
    private static final Logger logger = LoggerFactory.getLogger(GSuiteConnector.class);
    private static final String SUSPENDED = "suspended";
    private static final String GROUPS = "groups";
    private static final String NEXTPAGETOKEN = "nextPageToken";
    private static final String USERS = "users";
    private static final String CONNECTOR_STORAGE_KEY_ACCESS_TOKEN_EXPIRY_DATE = "ACCESS_TOKEN_EXPIRY_DATE";
    private static final String DOMAIN = "domain";
    private static final String CUSTOMER = "customer";
    private static final String ATTRIBUTE_GROUP_EMAIL = "groupEmailAddresses";
    public static final String PROFILE_PICTURE_ATTRIBUTE_ETAG = "etag";
    public static final String PROFILE_PICTURE_ATTRIBUTE_PHOTO_DATA = "photoData";
    public static final String MAX_RESULTS = "maxResults";
    private static final List<String> CONNECTOR_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("orgUnitPath", "kind", "suspended", "name.givenName", "name.familyName", "name.fullName", "primaryEmail", "id", "photo.etag", "photo.photoData", "GROUPS", "groupEmailAddresses"));

    GSuiteConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull GSuiteConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/GSuiteConnector.json");
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        if (this.getRequiredGroupCheckerHolder().hasRequiredGroupsConfigured()) {
            try {
                this.fetchUsersFromRequiredGroups(syncFunction, syncStatusFacade);
            }
            catch (GeneralSyncException | RequestFailedException e) {
                syncStatusFacade.fail("Reading required group data failed", e, logger);
            }
        } else {
            syncStatusFacade.add("No required groups are configured, fetching all users", SyncStatusFacade.LogLevel.INFO, logger);
            this.syncUsers(null, syncFunction, syncStatusFacade);
        }
    }

    private void fetchUsersFromRequiredGroups(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException, RequestFailedException {
        Set<String> requiredGroupIds = this.fetchRequiredConnectorGroups(this.getRequiredGroupCheckerHolder(), syncStatusFacade).stream().map(ConnectorGroup::getId).collect(Collectors.toSet());
        syncStatusFacade.add("Loading members of " + requiredGroupIds.size() + " groups", SyncStatusFacade.LogLevel.INFO, logger);
        Set<String> memberIds = this.readMemberIds(requiredGroupIds);
        syncStatusFacade.add("Found " + memberIds.size() + " members of required groups", SyncStatusFacade.LogLevel.INFO, logger);
        this.syncUsers(memberIds, syncFunction, syncStatusFacade);
    }

    @Override
    @Nonnull
    public Set<ConnectorGroup> fetchRequiredConnectorGroups(@Nonnull RequiredGroupCheckerHolder requiredGroupCheckerHolder, @Nonnull SyncStatusFacade syncStatusFacade) throws GeneralSyncException {
        HashSet<ConnectorGroup> requiredConnectorGroups = new HashSet<ConnectorGroup>();
        String nextPageToken = null;
        do {
            ResponseWrapper responseWrapper;
            HttpUrl.Builder urlBuilder = this.getUrlBase(true, true, nextPageToken).addPathSegment(GROUPS);
            String urlString = urlBuilder.build().toString();
            if (logger.isDebugEnabled()) {
                logger.debug("Fetching requiredConnectorGroups with URL {}", (Object)urlString);
            }
            if (!(responseWrapper = this.performGetRequest(urlString)).isSuccess()) {
                syncStatusFacade.fail("Fetching requiredConnectorGroups failed", responseWrapper.getCode(), responseWrapper.getMessage(), responseWrapper.getBody(), logger);
                return Collections.emptySet();
            }
            StructuredData responseData = responseWrapper.getParsedJson();
            nextPageToken = responseData.findString(NEXTPAGETOKEN);
            StructuredData groupData = responseData.find(GROUPS);
            if (groupData == null || !groupData.isList()) {
                syncStatusFacade.fail("Group response is no list or empty response", logger);
                logger.warn("Unexpected group-data {}", (Object)groupData);
                return Collections.emptySet();
            }
            requiredGroupCheckerHolder.getLocalRequiredGroupChecker().ifPresent(requiredGroupChecker -> groupData.asList().stream().map(currentGroup -> {
                String id = currentGroup.findString("id");
                String name = currentGroup.findString("name");
                return new ConnectorGroup(id, name, JSONUtil.asJson((Object)currentGroup));
            }).filter(requiredGroupChecker::isRequiredGroup).forEach(requiredConnectorGroups::add));
        } while (!StringUtil.isNullOrEmpty((String)nextPageToken));
        return requiredConnectorGroups;
    }

    public Set<String> readMemberIds(Set<String> groupIds) throws RequestFailedException {
        HashSet<String> memberIds = new HashSet<String>();
        for (String groupId : groupIds) {
            String nextPageToken = null;
            do {
                HttpUrl.Builder urlBuilder;
                ResponseWrapper responseWrapper;
                if (!(responseWrapper = this.performGetRequest((urlBuilder = this.getUrlBase(false, true, nextPageToken).addPathSegment(GROUPS).addPathSegment(groupId).addPathSegment("members").addQueryParameter("includeDerivedMembership", "true")).build().toString())).isSuccess()) {
                    throw new RequestFailedException("Fetching members failed for group " + groupId, responseWrapper.getCode(), responseWrapper.getMessage());
                }
                StructuredData responseData = responseWrapper.getParsedJson();
                nextPageToken = responseData.findString(NEXTPAGETOKEN);
                StructuredData foundIds = responseData.find("members.collect{it.id}");
                if (foundIds == null || !foundIds.isList()) continue;
                memberIds.addAll(foundIds.asStringList());
            } while (nextPageToken != null);
        }
        return memberIds;
    }

    protected void syncUsers(@Nullable Collection<String> idWhitelist, @Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        String nextPageToken = null;
        do {
            HttpUrl.Builder urlBuilder = this.getUrlBase(true, true, nextPageToken).addPathSegment(USERS);
            String urlString = urlBuilder.build().toString();
            if (logger.isDebugEnabled()) {
                logger.debug("Fetching users with URL {}", (Object)urlString);
            }
            ResponseWrapper responseWrapper = this.performGetRequest(urlString);
            if (logger.isDebugEnabled()) {
                logger.debug("Received Body: {}", (Object)JSONUtil.asJson((Object)responseWrapper.getBody()));
            }
            if (!responseWrapper.isSuccess()) {
                syncStatusFacade.fail("Fetching users failed, unexpected response: " + responseWrapper.getCode() + ": " + responseWrapper.getMessage(), logger);
                return;
            }
            StructuredData responseData = responseWrapper.getParsedJson();
            nextPageToken = responseData.findString(NEXTPAGETOKEN);
            StructuredData foundUsers = responseData.find(USERS);
            if (foundUsers == null || !foundUsers.isList()) continue;
            for (StructuredData userAttributes : foundUsers.asList()) {
                String userIdentifier = userAttributes.findString("id");
                if (userIdentifier == null) {
                    syncStatusFacade.failPartially("No id found for user", logger);
                    continue;
                }
                if (idWhitelist != null && !idWhitelist.contains(userIdentifier)) continue;
                try {
                    this.addGroupInformation(userAttributes);
                    this.addProfilePictureAttributes(userAttributes, syncStatusFacade);
                    syncFunction.accept(userAttributes.asMap());
                }
                catch (RequestFailedException | UserRelatedSyncException e) {
                    syncStatusFacade.failPartially("Fetching groups for " + userIdentifier + " failed", e, logger);
                }
            }
        } while (nextPageToken != null);
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        HttpUrl url;
        ResponseWrapper responseWrapper;
        SyncStatusFacade syncStatusFacade = SyncStatusFacade.nullFacade();
        if (this.isAccessTokenInValid()) {
            try {
                this.refreshAccessToken();
            }
            catch (AccessTokenException e) {
                return FindUserResult.failed("Refreshing Access Token failed, maybe re-authorization is necessary.");
            }
        }
        if ((responseWrapper = this.performGetRequest((url = this.getUrlBase(false, false, null).addPathSegment(USERS).addPathSegment(identifier).build()).toString())).isNotFound()) {
            return FindUserResult.notFound();
        }
        if (!responseWrapper.isSuccess()) {
            return FindUserResult.failed(responseWrapper.getMessage());
        }
        try {
            StructuredData userAttributes = responseWrapper.getParsedJson();
            this.addGroupInformation(userAttributes);
            this.addProfilePictureAttributes(userAttributes, syncStatusFacade);
            StructuredData groupData = userAttributes.asMap().get((Object)"GROUPS");
            if (groupData != null) {
                if (((GSuiteConnectorConfiguration)this.configuration).isIgnoreRequiredConnectorGroupsOnSingleUserSync() || GSuiteConnector.matchesRequiredConnectorGroups(((GSuiteConnectorConfiguration)this.configuration).getRequiredConnectorGroups(), groupData.asStringList())) {
                    return FindUserResult.found(userAttributes);
                }
                return FindUserResult.preFiltered(userAttributes);
            }
            return FindUserResult.failed("GROUPS has no value");
        }
        catch (RequestFailedException | UserRelatedSyncException e) {
            return FindUserResult.failed(e);
        }
    }

    public void addGroupInformation(@Nonnull StructuredData userAttributes) throws RequestFailedException {
        StructuredData responseData;
        HashSet groupNames = new HashSet();
        HashSet groupEmailAddresses = new HashSet();
        String userKey = userAttributes.findString("id");
        if (userKey == null) {
            throw new RequestFailedException("No id-attribute found");
        }
        String nextPageToken = null;
        do {
            StructuredData foundEmails;
            HttpUrl.Builder urlBuilder;
            ResponseWrapper response;
            if (!(response = this.performGetRequest((urlBuilder = this.getUrlBase(false, true, nextPageToken).addPathSegment(GROUPS).addQueryParameter("userKey", userKey)).build().toString())).isSuccess()) {
                throw new RequestFailedException("Fetching groups for " + userKey + " failed", response.getCode(), response.getMessage());
            }
            responseData = response.getParsedJson();
            StructuredData foundGroupNames = responseData.find("groups.collect{it.name}");
            if (foundGroupNames != null && foundGroupNames.isList()) {
                groupNames.addAll(foundGroupNames.asStringList());
            }
            if ((foundEmails = responseData.find("groups.collect{it.email}")) == null || !foundEmails.isList()) continue;
            groupEmailAddresses.addAll(foundEmails.asStringList());
        } while ((nextPageToken = responseData.findString(NEXTPAGETOKEN)) != null);
        userAttributes.put((Object)"GROUPS", groupNames);
        userAttributes.put((Object)ATTRIBUTE_GROUP_EMAIL, groupEmailAddresses);
    }

    private void addProfilePictureAttributes(@Nonnull StructuredData userAttributes, @Nonnull SyncStatusFacade syncStatusFacade) throws UserRelatedSyncException {
        if (!((GSuiteConnectorConfiguration)this.configuration).isFetchProfilePicture()) {
            return;
        }
        MapStructuredData photoAttributes = StructuredData.create();
        String userKey = userAttributes.findString("id");
        if (userKey == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping user without id: {}", (Object)JSONUtil.asJson((Object)userAttributes));
            }
            throw new UserRelatedSyncException("Skipping user with empty id");
        }
        String url = this.getUrlBase(false, false, null).addPathSegment(USERS).addPathSegment(userKey).addPathSegment("photos").addPathSegment("thumbnail").toString();
        ResponseWrapper response = this.performGetRequest(url);
        if (response.getCode() == 404) {
            logger.debug("No profile picture found for user {}", (Object)userKey);
            photoAttributes.put((Object)PROFILE_PICTURE_ATTRIBUTE_ETAG, (Object)"");
            photoAttributes.put((Object)PROFILE_PICTURE_ATTRIBUTE_PHOTO_DATA, (Object)"");
            userAttributes.put((Object)"photo", (Object)photoAttributes);
            return;
        }
        if (!response.isSuccess()) {
            syncStatusFacade.failPartially("Could not fetch profile picture for user " + userKey, logger);
            return;
        }
        photoAttributes = response.getParsedJson();
        String mimeType = photoAttributes.findString("mimeType");
        if (!ProfilePictureAdapter.SUPPORTED_MIME_TYPES.contains(mimeType)) {
            syncStatusFacade.failPartially("MIME type " + mimeType + " of profile picture not supported.", logger);
            photoAttributes.put((Object)PROFILE_PICTURE_ATTRIBUTE_ETAG, (Object)"");
            userAttributes.put((Object)"photo", (Object)photoAttributes);
            return;
        }
        String etag = photoAttributes.findString(PROFILE_PICTURE_ATTRIBUTE_ETAG);
        String assignedProfilePictureFilename = this.getAttributeValueFromUser(GSUITE_ATTRIBUTE_ID, userKey, "ATTR_PROFILE_PICTURE_FILENAME");
        if (assignedProfilePictureFilename != null && etag != null && assignedProfilePictureFilename.contains(etag.replaceAll("[^a-zA-Z0-9]", ""))) {
            logger.debug("Profile picture is already assigned to the user, so the attributes are not added to the user, etag: {}, existingFilename: {}", (Object)etag, (Object)assignedProfilePictureFilename);
            return;
        }
        String photoData = photoAttributes.findString(PROFILE_PICTURE_ATTRIBUTE_PHOTO_DATA);
        String avatarBase64 = Base64.getEncoder().encodeToString(Base64.getUrlDecoder().decode(photoData));
        photoAttributes.put((Object)PROFILE_PICTURE_ATTRIBUTE_PHOTO_DATA, (Object)avatarBase64);
        userAttributes.put((Object)"photo", (Object)photoAttributes);
    }

    private HttpUrl.Builder getUrlBase(boolean includeDomainOrCustomer, boolean includePagination, @Nullable String nextPageToken) {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("www.googleapis.com").addPathSegment("admin").addPathSegment("directory").addPathSegment("v1");
        if (includeDomainOrCustomer) {
            if (((GSuiteConnectorConfiguration)this.configuration).getDomain() != null && !((GSuiteConnectorConfiguration)this.configuration).getDomain().isEmpty()) {
                urlBuilder.addQueryParameter(DOMAIN, ((GSuiteConnectorConfiguration)this.configuration).getDomain());
            }
            if (((GSuiteConnectorConfiguration)this.configuration).getCustomerId() != null && !((GSuiteConnectorConfiguration)this.configuration).getCustomerId().isEmpty()) {
                urlBuilder.addQueryParameter(CUSTOMER, ((GSuiteConnectorConfiguration)this.configuration).getCustomerId());
            }
        }
        if (includePagination) {
            if (nextPageToken == null) {
                urlBuilder.addQueryParameter(MAX_RESULTS, String.valueOf(((GSuiteConnectorConfiguration)this.configuration).getBatchSize()));
            } else {
                urlBuilder.addQueryParameter("pageToken", nextPageToken);
            }
        }
        return urlBuilder;
    }

    @Override
    @Nonnull
    public String getTokenUrl() {
        return "https://www.googleapis.com/oauth2/v4/token";
    }

    @Override
    @Nonnull
    public Optional<String> getScope() {
        return Optional.of("https://www.googleapis.com/auth/admin.directory.user https://www.googleapis.com/auth/admin.directory.group.readonly");
    }

    @Override
    @Nonnull
    public String getAuthorizeUrl() {
        return "https://accounts.google.com/o/oauth2/v2/auth";
    }

    @Override
    @Nonnull
    public Class<GSuiteConnectorConfiguration> getConfigurationClass() {
        return GSuiteConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Google Cloud Identity";
    }

    @Override
    public List<String> getConnectorAttributes() {
        return CONNECTOR_ATTRIBUTES;
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    protected boolean isAccessTokenInValid() {
        if (!this.getConnectorStorageValue("ACCESS_TOKEN").isPresent()) {
            return true;
        }
        if (!this.getConnectorStorageValue(CONNECTOR_STORAGE_KEY_ACCESS_TOKEN_EXPIRY_DATE).isPresent()) {
            return true;
        }
        long accessTokenExpirationDate = Long.parseLong(this.getConnectorStorageValue(CONNECTOR_STORAGE_KEY_ACCESS_TOKEN_EXPIRY_DATE).orElse("0"));
        if (accessTokenExpirationDate > 0L) {
            Instant instant = Instant.ofEpochMilli(accessTokenExpirationDate);
            return !instant.isAfter(Instant.now());
        }
        return true;
    }

    @Override
    public boolean isCanFetchRequiredConnectorGroups() {
        return true;
    }

    @Override
    @Nonnull
    public List<ConnectionTestResultEntity.EndpointResult> doConnectionTest() {
        ArrayList<ConnectionTestResultEntity.EndpointResult> tests = new ArrayList<ConnectionTestResultEntity.EndpointResult>();
        if (!this.isAuthorizationRequired()) {
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Authorization Valid", "", true, "OK", null));
        } else {
            tests.add(ConnectionTestResultEntity.EndpointResult.createError("Authorization Valid", "", false, "FAIL", null, "Please start the re-authorization, there is no access token present"));
        }
        try {
            String groupsUrl = this.getUrlBase(true, true, null).addPathSegment(GROUPS).addQueryParameter(MAX_RESULTS, "1").toString();
            ResponseWrapper res = this.performGetRequest(groupsUrl);
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Groups", groupsUrl, res.isSuccess(), String.valueOf(res.getCode()), res.getBody()));
        }
        catch (Exception e) {
            tests.add(ConnectionTestResultEntity.EndpointResult.createError("Fetch Groups", "", false, "FAIL", null, "This test failed, please refer to the log"));
        }
        MapStructuredData testUser = StructuredData.create();
        try {
            String usersUrl = this.getUrlBase(true, true, null).addPathSegment(USERS).addQueryParameter(MAX_RESULTS, "1").toString();
            ResponseWrapper res = this.performGetRequest(usersUrl);
            if (res.isSuccess()) {
                testUser = res.getParsedJson();
            }
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Users", usersUrl, res.isSuccess(), String.valueOf(res.getCode()), res.getBody()));
        }
        catch (Exception e) {
            tests.add(ConnectionTestResultEntity.EndpointResult.createError("Fetch Users", "", false, "FAIL", null, "This test failed, please refer to the log"));
        }
        if (((GSuiteConnectorConfiguration)this.configuration).isFetchProfilePicture()) {
            String userKey = null;
            try {
                userKey = testUser.asMap().get((Object)USERS).asList().get(0).asMap().get((Object)"id").asString();
            }
            catch (Exception e) {
                tests.add(ConnectionTestResultEntity.EndpointResult.createError("Fetch Profile Picture", "", false, "SKIPPED", null, "Cannot run test because we did not get a user from the previous test. There are either no users in your Google Cloud Identity or the previous test failed."));
                return tests;
            }
            String profilePictureUrl = this.getUrlBase(false, false, null).addPathSegment(USERS).addPathSegment(userKey).addPathSegment("photos").addPathSegment("thumbnail").toString();
            ResponseWrapper res = this.performGetRequest(profilePictureUrl);
            String fetchProfilePicture = "Fetch Profile Picture";
            if (res.getCode() == 404) {
                tests.add(ConnectionTestResultEntity.EndpointResult.createInfo(fetchProfilePicture, profilePictureUrl, true, res.getCode() + "", res.getBody(), "Even if it looks like a failure, this is a successful test. The test user has no image set. However, the test shows that the token permissions are set correctly"));
            } else {
                tests.add(ConnectionTestResultEntity.EndpointResult.create(fetchProfilePicture, profilePictureUrl, res.isSuccess(), res.getCode() + "", res.getBody()));
            }
        }
        return tests;
    }
}

