/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.license.LicenseHandler;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.atlascompat.api.exception.AtlasCompatApiException;
import de.resolution.reconfigure.api.ApplicationInformation;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class ApplicationInformationImpl
implements ApplicationInformation {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInformationImpl.class);
    private final ApplicationInformation.Application application;
    private final Set<ApplicationInformation.SubApplication> subApplications;
    private final String applicationDisplayName;
    private final String applicationVersion;
    private final String applicationBaseUrl;
    private final String applicationContextPath;
    private final String applicationLoginUrl;
    private final String applicationServerId;

    public ApplicationInformationImpl(ApplicationProperties applicationProperties, AtlasCompatApiFactory atlasCompatApiFactory, LoginUriProvider loginUriProvider, LicenseHandler licenseHandler, String frontendUrl, boolean isSupportInfo) {
        HashSet subApplicationSet = new HashSet();
        switch (applicationProperties.getPlatformId()) {
            case "jira": {
                this.application = ApplicationInformation.Application.JIRA;
                this.applicationDisplayName = "Jira";
                atlasCompatApiFactory.getJiraPlatformApi().ifPresent(api -> {
                    try {
                        if (api.isApplicationInstalled("jira-servicedesk")) {
                            subApplicationSet.add(ApplicationInformation.SubApplication.JIRA_SERVICE_DESK);
                        }
                        if (api.isApplicationInstalled("jira-software")) {
                            subApplicationSet.add(ApplicationInformation.SubApplication.JIRA_SOFTWARE);
                        }
                    }
                    catch (AtlasCompatApiException e) {
                        logger.warn("Checking for installed applications failed", (Throwable)e);
                    }
                });
                break;
            }
            case "conf": {
                this.application = ApplicationInformation.Application.CONFLUENCE;
                this.applicationDisplayName = "Confluence";
                break;
            }
            case "bitbucket": {
                this.application = ApplicationInformation.Application.BITBUCKET;
                this.applicationDisplayName = "Bitbucket";
                break;
            }
            case "bamboo": {
                this.application = ApplicationInformation.Application.BAMBOO;
                this.applicationDisplayName = "Bamboo";
                break;
            }
            case "fisheye": {
                this.application = ApplicationInformation.Application.FECRU;
                this.applicationDisplayName = "Fisheye/Crucible";
                break;
            }
            case "crowd": {
                this.application = ApplicationInformation.Application.CROWD;
                this.applicationDisplayName = "Crowd";
                break;
            }
            default: {
                this.application = ApplicationInformation.Application.OTHER;
                this.applicationDisplayName = applicationProperties.getDisplayName();
            }
        }
        this.subApplications = Collections.unmodifiableSet(subApplicationSet);
        this.applicationVersion = applicationProperties.getVersion();
        this.applicationBaseUrl = applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        this.applicationContextPath = applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        this.applicationServerId = licenseHandler.getServerId();
        this.applicationLoginUrl = frontendUrl == null ? null : (isSupportInfo ? loginUriProvider.getLoginUri(URI.create(frontendUrl)).toASCIIString() : loginUriProvider.getLoginUri(URI.create(frontendUrl + "?QUERYPLACEHOLDER")).toASCIIString());
    }

    @Override
    public ApplicationInformation.Application getApplication() {
        return this.application;
    }

    @Override
    public String getApplicationDisplayName() {
        return this.applicationDisplayName;
    }

    @Override
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Override
    public String getApplicationBaseUrl() {
        return this.applicationBaseUrl;
    }

    @Override
    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    @Override
    public String getApplicationLoginUrl() {
        return this.applicationLoginUrl;
    }

    @Override
    public String getApplicationServerId() {
        return this.applicationServerId;
    }

    @Override
    public Set<ApplicationInformation.SubApplication> getSubApplications() {
        return this.subApplications;
    }
}

