/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.legacyloader;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.MutableRegexAndReplacement;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V5IdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedIdPConfiguration;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticationAttribute;
import com.resolution.samlwrapper.api.SAMLWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude
public class V4IdpConfiguration
implements Comparable<V4IdpConfiguration>,
VersionedIdPConfiguration {
    public Integer id = null;
    public Integer weight;
    public String name;
    public String description;
    public String postBindingURL;
    public String postBindingLogoutURL;
    public String redirectBindingURL;
    public String redirectBindingLogoutURL;
    public SAMLWrapper.Binding selectedLoginBinding = SAMLWrapper.Binding.POST;
    public LogoutBinding selectedLogoutBinding = LogoutBinding.DISABLE;
    public SAMLWrapper.NameIdFormat nameIdFormatInRequest = SAMLWrapper.NameIdFormat.NONE;
    public String entityId;
    @XmlElementWrapper(name="certificates")
    @XmlElement(name="certificate")
    public List<String> certificates = new ArrayList<String>();
    public boolean useridMatchesNameId = true;
    public String relayStateParameterName = "RelayState";
    public String useridAttribute = null;
    public String fullnameAttribute = null;
    public String emailAttribute = null;
    public String groupAttribute = null;
    public String organizationAttribute = null;
    public AuthenticationAttribute authenticationAttribute = AuthenticationAttribute.USERNAME;
    @XmlElementWrapper(name="additionalAttributes")
    public Map<String, String> additionalAttributes = new HashMap<String, String>();
    @XmlElementWrapper(name="groupsForNewUsers")
    @XmlElement(name="groupForNewUsers")
    public List<String> groupsForNewUsers = new ArrayList<String>();
    @XmlElementWrapper(name="groupsForNewSdCustomers")
    @XmlElement(name="groupForNewSdCustomers")
    public List<String> groupsForNewSdCustomers = new ArrayList<String>();
    @XmlElementWrapper(name="organizationsForNewSdCustomers")
    @XmlElement(name="organizationForNewSdCustomers")
    public List<String> organizationsForNewSdCustomers = new ArrayList<String>();
    public String useridTransformationRegex;
    public String useridTransformationReplacement;
    public Long directoryIdForNewUsers = 1L;
    public boolean removeFromGroups = false;
    public boolean addNonExistingGroups = false;
    public boolean addNonExistingOrganizations = false;
    public boolean updateExisting = false;
    public boolean enableUserUpdate = false;
    public boolean enableUserCreation = false;
    public boolean lowercaseConvert = false;
    public boolean lowercaseConvertGroups = false;
    public boolean signRequests = true;
    public String metadataurl;
    public String metadataxml;
    public boolean metadataignorecert;
    public boolean useMetadataxml = false;
    public boolean acceptUnsignedLogoutResponse = true;
    public boolean acceptUnsignedLogoutRequest = false;
    public boolean useUrlFromRequest = false;
    public boolean acceptLogoutRequestWithoutSessionIndex = false;
    @XmlElementWrapper(name="attributeMapping")
    public HashMap<String, String> attributeMapping = new HashMap();
    public boolean includeProtocolBindingInRequest = true;
    public String frontendId = null;

    public V4IdpConfiguration() {
    }

    public V4IdpConfiguration(V4IdpConfiguration other) {
        this.id = other.id;
        this.weight = other.weight;
        this.name = other.name;
        this.description = other.description;
        this.postBindingURL = other.postBindingURL;
        this.postBindingLogoutURL = other.postBindingLogoutURL;
        this.redirectBindingURL = other.redirectBindingURL;
        this.redirectBindingLogoutURL = other.redirectBindingLogoutURL;
        this.selectedLoginBinding = other.selectedLoginBinding;
        this.selectedLogoutBinding = other.selectedLogoutBinding;
        this.nameIdFormatInRequest = other.nameIdFormatInRequest;
        this.entityId = other.entityId;
        this.useUrlFromRequest = other.useUrlFromRequest;
        this.certificates = new ArrayList<String>();
        this.certificates.addAll(other.certificates);
        this.relayStateParameterName = other.relayStateParameterName;
        this.useridMatchesNameId = other.useridMatchesNameId;
        this.useridAttribute = other.useridAttribute;
        this.fullnameAttribute = other.fullnameAttribute;
        this.emailAttribute = other.emailAttribute;
        this.groupAttribute = other.groupAttribute;
        this.organizationAttribute = other.organizationAttribute;
        this.organizationsForNewSdCustomers = new ArrayList<String>();
        this.organizationsForNewSdCustomers.addAll(other.organizationsForNewSdCustomers);
        this.acceptUnsignedLogoutResponse = other.acceptUnsignedLogoutResponse;
        this.acceptUnsignedLogoutRequest = other.acceptUnsignedLogoutRequest;
        this.acceptLogoutRequestWithoutSessionIndex = other.acceptLogoutRequestWithoutSessionIndex;
        this.authenticationAttribute = other.authenticationAttribute;
        this.additionalAttributes.putAll(other.additionalAttributes);
        this.groupsForNewUsers = other.groupsForNewUsers;
        this.groupsForNewSdCustomers = other.groupsForNewSdCustomers;
        this.useridTransformationRegex = other.useridTransformationRegex;
        this.useridTransformationReplacement = other.useridTransformationReplacement;
        this.directoryIdForNewUsers = other.directoryIdForNewUsers;
        this.removeFromGroups = other.removeFromGroups;
        this.updateExisting = other.updateExisting;
        this.addNonExistingGroups = other.addNonExistingGroups;
        this.addNonExistingOrganizations = other.addNonExistingOrganizations;
        this.enableUserUpdate = other.enableUserUpdate;
        this.enableUserCreation = other.enableUserCreation;
        this.lowercaseConvert = other.lowercaseConvert;
        this.lowercaseConvertGroups = other.lowercaseConvertGroups;
        this.signRequests = other.signRequests;
        this.includeProtocolBindingInRequest = other.includeProtocolBindingInRequest;
        this.metadataurl = other.metadataurl;
        this.metadataxml = other.metadataxml;
        this.metadataignorecert = other.metadataignorecert;
        this.useMetadataxml = other.useMetadataxml;
        this.attributeMapping = new HashMap();
        this.attributeMapping.putAll(other.attributeMapping);
    }

    @Override
    public V5IdpConfiguration migrateToNewerModelVersion() {
        V5IdpConfiguration migrated = new V5IdpConfiguration();
        migrated.id = this.id;
        migrated.weight = this.weight;
        migrated.name = this.name;
        migrated.description = this.description;
        migrated.postBindingURL = this.postBindingURL;
        migrated.postBindingLogoutURL = this.postBindingLogoutURL;
        migrated.redirectBindingURL = this.redirectBindingURL;
        migrated.redirectBindingLogoutURL = this.redirectBindingLogoutURL;
        migrated.selectedLoginBinding = this.selectedLoginBinding;
        migrated.selectedLogoutBinding = V4IdpConfiguration.translate(this.selectedLogoutBinding);
        migrated.nameIdFormatInRequest = this.nameIdFormatInRequest;
        migrated.entityId = this.entityId;
        migrated.useUrlFromRequest = this.useUrlFromRequest;
        migrated.certificates = new ArrayList<String>();
        migrated.certificates.addAll(this.certificates);
        migrated.relayStateParameterName = this.relayStateParameterName;
        migrated.useridMatchesNameId = this.useridMatchesNameId;
        migrated.useridAttribute = this.useridAttribute;
        migrated.fullnameAttribute = this.fullnameAttribute;
        migrated.emailAttribute = this.emailAttribute;
        migrated.groupAttribute = this.groupAttribute;
        migrated.organizationAttribute = this.organizationAttribute;
        migrated.organizationsForNewSdCustomers = new ArrayList<String>();
        migrated.organizationsForNewSdCustomers.addAll(this.organizationsForNewSdCustomers);
        migrated.acceptUnsignedLogoutResponse = this.acceptUnsignedLogoutResponse;
        migrated.acceptUnsignedLogoutRequest = this.acceptUnsignedLogoutRequest;
        migrated.acceptLogoutRequestWithoutSessionIndex = this.acceptLogoutRequestWithoutSessionIndex;
        migrated.authenticationAttribute = this.authenticationAttribute;
        migrated.additionalAttributes.putAll(this.additionalAttributes);
        migrated.groupsForNewUsers = this.groupsForNewUsers;
        migrated.groupsForNewSdCustomers = this.groupsForNewSdCustomers;
        if (this.useridTransformationRegex != null && !this.useridTransformationRegex.trim().isEmpty() && this.useridTransformationReplacement != null && !this.useridTransformationReplacement.trim().isEmpty()) {
            migrated.useridTransformations.add(new MutableRegexAndReplacement(this.useridTransformationRegex, this.useridTransformationReplacement));
        }
        migrated.directoryIdForNewUsers = this.directoryIdForNewUsers;
        migrated.removeFromGroups = this.removeFromGroups;
        migrated.updateExisting = this.updateExisting;
        migrated.addNonExistingGroups = this.addNonExistingGroups;
        migrated.addNonExistingOrganizations = this.addNonExistingOrganizations;
        migrated.enableUserUpdate = this.enableUserUpdate;
        migrated.enableUserCreation = this.enableUserCreation;
        migrated.lowercaseConvert = this.lowercaseConvert;
        migrated.lowercaseConvertGroups = this.lowercaseConvertGroups;
        migrated.signRequests = this.signRequests;
        migrated.includeProtocolBindingInRequest = this.includeProtocolBindingInRequest;
        migrated.metadataurl = this.metadataurl;
        migrated.metadataxml = this.metadataxml;
        migrated.metadataignorecert = this.metadataignorecert;
        migrated.useMetadataxml = this.useMetadataxml;
        migrated.attributeMapping = new HashMap();
        migrated.attributeMapping.putAll(this.attributeMapping);
        return migrated;
    }

    @Override
    public int compareTo(V4IdpConfiguration other) {
        return this.weight.compareTo(other.weight);
    }

    private static V5IdpConfiguration.LogoutBinding translate(LogoutBinding v4LogoutBinding) {
        switch (v4LogoutBinding) {
            case REDIRECT: {
                return V5IdpConfiguration.LogoutBinding.REDIRECT;
            }
            case DISABLE: {
                return V5IdpConfiguration.LogoutBinding.DISABLE;
            }
            case POST: {
                return V5IdpConfiguration.LogoutBinding.POST;
            }
        }
        return V5IdpConfiguration.LogoutBinding.DISABLE;
    }

    public static enum LogoutBinding {
        POST,
        REDIRECT,
        DISABLE;

    }
}

