/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.cleanup;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.resolution.atlasplugins.samlsso.cleanup.CleanupJobRunner;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfigurationListener;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import java.security.SecureRandom;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CleanupJobScheduler
implements PluginConfigurationListener,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(CleanupJobScheduler.class);
    private static final Random RANDOM = new SecureRandom();
    private static final int MIN_DELAY = 15000;
    private static final int MAX_JITTER = 10000;
    private final SchedulerService schedulerService;
    private final RunningConfiguration pluginConfiguration;
    private final JobId jobId = JobId.of((String)"com.atlassian.atlasplugins.samlsso.cleanup.cleanupjob");

    @Autowired
    public CleanupJobScheduler(@ComponentImport SchedulerService schedulerService, RunningConfiguration pluginConfiguration) {
        this.schedulerService = schedulerService;
        this.pluginConfiguration = pluginConfiguration;
        pluginConfiguration.addListener(this);
        this.stopOldScheduledJobs();
    }

    public void destroy() {
        logger.debug("Removing listener from PluginConfiguration");
        this.pluginConfiguration.removeListener(this);
    }

    public void scheduleCleanup() {
        int jitter = RANDOM.nextInt(10000);
        Date firstRun = new Date(System.currentTimeMillis() + 15000L + (long)jitter);
        int intervalInMillis = this.pluginConfiguration.getTrackerCleanupIntervalInMinutes() * 60 * 1000;
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)CleanupJobRunner.JOB_RUNNER_KEY).withSchedule(Schedule.forInterval((long)intervalInMillis, (Date)firstRun)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        try {
            logger.info("Scheduling Cleanup Job {} with the interval {}, first run is {} ", new Object[]{this.jobId, intervalInMillis, firstRun});
            this.schedulerService.scheduleJob(this.jobId, jobConfig);
        }
        catch (SchedulerServiceException e) {
            logger.error("Scheduling cleanup job failed!", (Throwable)e);
        }
    }

    public void stopCleanupSchedule() {
        logger.info("Unscheduling Cleanup Job {}", (Object)this.jobId);
        this.schedulerService.unscheduleJob(this.jobId);
    }

    @Override
    public void configurationUpdated() {
        this.scheduleCleanup();
    }

    @Override
    public void configurationCleared() {
        this.stopCleanupSchedule();
    }

    public void stopOldScheduledJobs() {
        try {
            List oldJobs = this.schedulerService.getJobsByJobRunnerKey(JobRunnerKey.of((String)"CompatibilityPluginScheduler.JobRunnerKey.com.resolution.atlasplugins.samlsso.cleanup.CleanupJobHandler"));
            if (oldJobs.isEmpty()) {
                logger.info("No old cleanup jobs found");
            } else {
                oldJobs.forEach(jobDetails -> {
                    this.schedulerService.unscheduleJob(jobDetails.getJobId());
                    logger.debug("Unscheduled old cleanup job {}", (Object)jobDetails.getJobId());
                });
            }
        }
        catch (Exception e) {
            logger.warn("Unscheduling old cleanup jobs failed", (Throwable)e);
        }
    }
}

